/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.googlecloudspanner.repository;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.ReadOnlyTransaction;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.util.Preconditions;
import org.togglz.googlecloudspanner.repository.SpannerFeatureStateDao;

public class DefaultSpannerFeatureStateDao
implements SpannerFeatureStateDao {
    static final String DEFAULT_FEATURE_STATE_TABLE_NAME = "FeatureToggle";
    static final String DEFAULT_STRATEGY_ID_COLUMN_NAME = "strategyId";
    static final String DEFAULT_ENABLED_COLUMN_NAME = "enabled";
    static final String DEFAULT_FEATURE_NAME_COLUMN_NAME = "featureName";
    static final String DEFAULT_STRATEGY_PARAMS_VALUES_COLUMN_NAME = "strategyParamsValues";
    static final String DEFAULT_STRATEGY_PARAMS_NAMES_COLUMN_NAME = "strategyParamsNames";
    private String featureStateTableName = "FeatureToggle";
    private String featureNameColumnName = "featureName";
    private String enabledColumnName = "enabled";
    private String strategyIdColumnName = "strategyId";
    private String strategyParamsNamesColumnName = "strategyParamsNames";
    private String strategyParamsValuesColumnName = "strategyParamsValues";

    public void setFeatureStateTableName(String featureStateTableName) {
        this.featureStateTableName = featureStateTableName;
    }

    public void setFeatureNameColumnName(String featureNameColumnName) {
        this.featureNameColumnName = featureNameColumnName;
    }

    public void setEnabledColumnName(String enabledColumnName) {
        this.enabledColumnName = enabledColumnName;
    }

    public void setStrategyIdColumnName(String strategyIdColumnName) {
        this.strategyIdColumnName = strategyIdColumnName;
    }

    public void setStrategyParamsNamesColumnName(String strategyParamsNamesColumnName) {
        this.strategyParamsNamesColumnName = strategyParamsNamesColumnName;
    }

    public void setStrategyParamsValuesColumnName(String strategyParamsValuesColumnName) {
        this.strategyParamsValuesColumnName = strategyParamsValuesColumnName;
    }

    @Override
    public Optional<FeatureState> select(Feature feature, ReadOnlyTransaction tx) {
        Struct rowFound = this.readRow(feature, tx);
        return Optional.ofNullable(rowFound).map(row -> this.fetchFeatureState(feature, (Struct)row));
    }

    private Struct readRow(Feature feature, ReadOnlyTransaction tx) {
        return tx.readRow(this.featureStateTableName, Key.of((Object[])new Object[]{feature.name()}), List.of(this.featureNameColumnName, this.enabledColumnName, this.strategyIdColumnName, this.strategyParamsNamesColumnName, this.strategyParamsValuesColumnName));
    }

    private FeatureState fetchFeatureState(Feature feature, Struct row) {
        boolean enabled = row.getBoolean(this.enabledColumnName);
        FeatureState state = new FeatureState(feature, enabled);
        String strategyId = this.getStrategyId(row);
        state.setStrategyId(strategyId);
        this.fetchStrategyParamsFromColumns(row, state);
        return state;
    }

    private void fetchStrategyParamsFromColumns(Struct row, FeatureState state) {
        List<String> names = this.valuesList(row, this.strategyParamsNamesColumnName);
        List<String> values = this.valuesList(row, this.strategyParamsValuesColumnName);
        Preconditions.checkState((names.size() == values.size() ? 1 : 0) != 0);
        for (int i = 0; i < names.size(); ++i) {
            String name = names.get(i);
            String value = values.get(i);
            state.setParameter(name, value);
        }
    }

    private List<String> valuesList(Struct row, String propertyName) {
        List values = row.getStringList(propertyName);
        if (values == null) {
            return Collections.emptyList();
        }
        return values;
    }

    private String getStrategyId(Struct row) {
        String strategyId = this.getStringOrNull(this.strategyIdColumnName, row);
        if (strategyId != null && !strategyId.isEmpty()) {
            return strategyId.trim();
        }
        return null;
    }

    private String getStringOrNull(String colName, Struct row) {
        return row.isNull(colName) ? null : row.getString(colName);
    }

    @Override
    public void upsert(FeatureState featureState, TransactionContext tx) {
        Map params = featureState.getParameterMap();
        if (params == null) {
            params = Collections.emptyMap();
        }
        ArrayList<String> strategyParamsNames = new ArrayList<String>(params.size());
        ArrayList<String> strategyParamsValues = new ArrayList<String>(params.size());
        for (String paramName : params.keySet()) {
            strategyParamsNames.add(paramName);
            strategyParamsValues.add((String)params.get(paramName));
        }
        tx.buffer(List.of(((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertOrUpdateBuilder((String)this.featureStateTableName).set(this.featureNameColumnName).to(featureState.getFeature().name())).set(this.enabledColumnName).to(featureState.isEnabled())).set(this.strategyIdColumnName).to(featureState.getStrategyId())).set(this.strategyParamsNamesColumnName).toStringArray(strategyParamsNames)).set(this.strategyParamsValuesColumnName).toStringArray(strategyParamsValues)).build()));
    }

    @Override
    public void delete(String featureName, TransactionContext tx) {
        tx.buffer(Mutation.delete((String)this.featureStateTableName, (Key)Key.of((Object[])new Object[]{featureName})));
    }
}

