/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.appengine.repository;

import com.google.appengine.api.NamespaceManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.util.Preconditions;

public class FixedNamespaceStateRepository
implements StateRepository {
    private final String namespace;
    private final StateRepository decorated;

    @Inject
    public FixedNamespaceStateRepository(@Named(value="togglzFixedNamespace") String namespace, @Named(value="togglzFixedNamespace") StateRepository decorated) {
        this.decorated = (StateRepository)Preconditions.checkNotNull((Object)decorated);
        NamespaceManager.validateNamespace((String)namespace);
        this.namespace = namespace;
    }

    public FeatureState getFeatureState(Feature feature) {
        return FixedNamespaceStateRepository.withinNamespace(this.namespace, () -> this.decorated.getFeatureState(feature));
    }

    public void setFeatureState(final FeatureState featureState) {
        FixedNamespaceStateRepository.withinNamespace(this.namespace, new VoidWork(){

            @Override
            void vrun() {
                FixedNamespaceStateRepository.this.decorated.setFeatureState(featureState);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R withinNamespace(String namespace, Work<R> work) {
        String oldNamespace = NamespaceManager.get();
        NamespaceManager.set((String)namespace);
        try {
            R r = work.run();
            return r;
        }
        finally {
            NamespaceManager.set((String)oldNamespace);
        }
    }

    static interface Work<T> {
        public T run();
    }

    static abstract class VoidWork
    implements Work<Void> {
        VoidWork() {
        }

        @Override
        public Void run() {
            this.vrun();
            return null;
        }

        abstract void vrun();
    }
}

