/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.appengine.repository;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.togglz.core.Feature;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.repository.StateRepository;

public class DatastoreStateRepository
implements StateRepository {
    public static final String STRATEGY_PARAMS_VALUES = "strategyParamsValues";
    public static final String STRATEGY_PARAMS_NAMES = "strategyParamsNames";
    public static final String STRATEGY_ID = "strategyId";
    public static final String ENABLED = "enabled";
    private final DatastoreService datastoreService;
    private String kind = "FeatureToggle";

    public DatastoreStateRepository(DatastoreService datastoreService) {
        this.datastoreService = datastoreService;
    }

    public DatastoreStateRepository(String kind, DatastoreService datastoreService) {
        this(datastoreService);
        this.kind = kind;
    }

    public FeatureState getFeatureState(Feature feature) {
        try {
            Key key = KeyFactory.createKey((String)this.kind(), (String)feature.name());
            return this.createFeatureState(feature, this.getInsideTransaction(key));
        }
        catch (EntityNotFoundException ignored) {
            return null;
        }
    }

    private FeatureState createFeatureState(Feature feature, Entity featureEntity) {
        Boolean enabled = (Boolean)featureEntity.getProperty(ENABLED);
        FeatureState state = new FeatureState(feature, enabled.booleanValue());
        String strategyId = (String)featureEntity.getProperty(STRATEGY_ID);
        if (strategyId != null && !strategyId.isEmpty()) {
            state.setStrategyId(strategyId.trim());
        }
        List strategyParamsNames = (List)featureEntity.getProperty(STRATEGY_PARAMS_NAMES);
        List strategyParamsValues = (List)featureEntity.getProperty(STRATEGY_PARAMS_VALUES);
        if (strategyParamsNames != null && strategyParamsValues != null && !strategyParamsNames.isEmpty() && !strategyParamsValues.isEmpty() && strategyParamsNames.size() == strategyParamsValues.size()) {
            for (int i = 0; i < strategyParamsNames.size(); ++i) {
                state.setParameter((String)strategyParamsNames.get(i), (String)strategyParamsValues.get(i));
            }
        }
        return state;
    }

    public void setFeatureState(FeatureState featureState) {
        Entity featureEntity = new Entity(this.kind(), featureState.getFeature().name());
        featureEntity.setUnindexedProperty(ENABLED, (Object)featureState.isEnabled());
        featureEntity.setUnindexedProperty(STRATEGY_ID, (Object)featureState.getStrategyId());
        Map params = featureState.getParameterMap();
        if (params != null && !params.isEmpty()) {
            ArrayList<String> strategyParamsNames = new ArrayList<String>(params.size());
            ArrayList<String> strategyParamsValues = new ArrayList<String>(params.size());
            for (String paramName : params.keySet()) {
                strategyParamsNames.add(paramName);
                strategyParamsValues.add((String)params.get(paramName));
            }
            featureEntity.setUnindexedProperty(STRATEGY_PARAMS_NAMES, strategyParamsNames);
            featureEntity.setUnindexedProperty(STRATEGY_PARAMS_VALUES, strategyParamsValues);
        }
        this.putInsideTransaction(featureEntity);
    }

    protected void putInsideTransaction(Entity featureEntity) {
        if (this.datastoreService.getCurrentTransaction(null) == null) {
            this.datastoreService.put(featureEntity);
        } else {
            Transaction txn = this.datastoreService.beginTransaction();
            try {
                this.datastoreService.put(txn, featureEntity);
                txn.commit();
            }
            finally {
                if (txn.isActive()) {
                    txn.rollback();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity getInsideTransaction(Key key) throws EntityNotFoundException {
        Entity featureEntity;
        if (this.datastoreService.getCurrentTransaction(null) == null) {
            featureEntity = this.datastoreService.get(key);
        } else {
            Transaction txn = this.datastoreService.beginTransaction();
            try {
                featureEntity = this.datastoreService.get(txn, key);
                txn.commit();
            }
            finally {
                if (txn.isActive()) {
                    txn.rollback();
                }
            }
        }
        return featureEntity;
    }

    protected String kind() {
        return this.kind;
    }
}

