/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.appengine.activation;

import com.google.appengine.api.utils.SystemProperty;
import java.util.List;
import org.togglz.core.activation.Parameter;
import org.togglz.core.activation.ParameterBuilder;
import org.togglz.core.repository.FeatureState;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.user.FeatureUser;
import org.togglz.core.util.Strings;

public class ApplicationVersionActivationStrategy
implements ActivationStrategy {
    public static final String ID = "gae_app_version";
    public static final String PARAM_VERSIONS = "version";

    public String getId() {
        return ID;
    }

    public String getName() {
        return "Appengine Application Versions";
    }

    public boolean isActive(FeatureState featureState, FeatureUser user) {
        String currentVersion;
        String allowedVersionsParam = featureState.getParameter(PARAM_VERSIONS);
        if (Strings.isNotBlank((String)allowedVersionsParam) && Strings.isNotBlank((String)(currentVersion = SystemProperty.applicationVersion.get()))) {
            List allowedVersions = Strings.splitAndTrim((String)allowedVersionsParam, (String)"[\\s,]+");
            for (String allowedVersion : allowedVersions) {
                if (!currentVersion.startsWith(allowedVersion)) continue;
                return true;
            }
        }
        return false;
    }

    public Parameter[] getParameters() {
        return new Parameter[]{ParameterBuilder.create((String)PARAM_VERSIONS).label("Application Versions").description("A comma-separated list of application versions for which the feature should be active.")};
    }
}

