/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.thymeleaf;

import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.extras.java8time.dialect.Java8TimeDialect;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;
import org.tiogasolutions.lib.thymeleaf.ClassPathTemplateResolver;

public class ThymeleafFactory {
    private static TemplateEngine _templateEngine;

    public synchronized TemplateEngine getTemplateEngine() {
        if (_templateEngine == null) {
            _templateEngine = new TemplateEngine();
            _templateEngine.setTemplateResolvers(this.createTemplateResolvers());
            _templateEngine.addDialect((IDialect)new Java8TimeDialect());
        }
        return _templateEngine;
    }

    protected Set<ITemplateResolver> createTemplateResolvers() {
        HashSet<ITemplateResolver> resolvers = new HashSet<ITemplateResolver>();
        resolvers.add((ITemplateResolver)this.createFileTemplateResolver(1));
        resolvers.add((ITemplateResolver)this.createUrlTemplateResolver(2));
        resolvers.add((ITemplateResolver)this.createClassPathTemplateResolver(3));
        return resolvers;
    }

    protected ClassPathTemplateResolver createClassPathTemplateResolver(int order) {
        ClassPathTemplateResolver classPathTemplateResolver = new ClassPathTemplateResolver();
        classPathTemplateResolver.setTemplateMode("HTML5");
        classPathTemplateResolver.setCacheable(false);
        classPathTemplateResolver.setOrder(order);
        return classPathTemplateResolver;
    }

    protected UrlTemplateResolver createUrlTemplateResolver(int order) {
        UrlTemplateResolver urlTemplateResolver = new UrlTemplateResolver();
        urlTemplateResolver.setTemplateMode("HTML5");
        urlTemplateResolver.setCacheable(false);
        urlTemplateResolver.setOrder(Integer.valueOf(order));
        return urlTemplateResolver;
    }

    protected FileTemplateResolver createFileTemplateResolver(int order) {
        FileTemplateResolver fileTemplateResolver = new FileTemplateResolver();
        fileTemplateResolver.setTemplateMode("HTML5");
        fileTemplateResolver.setCacheable(false);
        fileTemplateResolver.setOrder(Integer.valueOf(1));
        return fileTemplateResolver;
    }

    public String process(String templatePath, Context context) {
        return this.getTemplateEngine().process(templatePath, (IContext)context);
    }

    public void process(String templatePath, Context context, Writer writer) {
        this.getTemplateEngine().process(templatePath, (IContext)context, writer);
    }
}

