/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.security.providers;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.tiogasolutions.dev.common.EqualsUtils;
import org.tiogasolutions.dev.domain.account.CurrentUserSource;
import org.tiogasolutions.dev.domain.account.CurrentUserStore;
import org.tiogasolutions.lib.security.CurrentUser;
import org.tiogasolutions.lib.security.providers.ProviderUtils;

public class CurrentUserSecurityProvider
extends AbstractUserDetailsAuthenticationProvider {
    private static final Log log = LogFactory.getLog(CurrentUserSecurityProvider.class);
    private final CurrentUserStore store;

    public CurrentUserSecurityProvider(CurrentUserStore store) {
        this.store = store;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (EqualsUtils.objectsNotEqual((Object)userDetails.getUsername(), (Object)authentication.getPrincipal())) {
            throw new BadCredentialsException("Invalid user name or password");
        }
        if (EqualsUtils.objectsNotEqual((Object)userDetails.getPassword(), (Object)authentication.getCredentials())) {
            throw new BadCredentialsException("Invalid user name or password");
        }
    }

    protected UserDetails retrieveUser(String userName, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (ProviderUtils.isGoogleAuthentication(authentication)) {
            throw new UsernameNotFoundException("Goolge Authentication Required");
        }
        CurrentUserSource source = this.store.getCurrentUserSourceByName(userName);
        if (source == null) {
            throw new BadCredentialsException("Invalid user name or password");
        }
        return new CurrentUser(source);
    }
}

