/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.lib.servlet.template;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.tiogasolutions.dev.common.StringUtils;
import org.tiogasolutions.lib.servlet.ServletUtils;
import org.tiogasolutions.lib.servlet.template.PageAttribute;
import org.tiogasolutions.lib.servlet.template.decorators.AnchorDecorator;
import org.tiogasolutions.lib.servlet.template.decorators.CompressionDecorator;
import org.tiogasolutions.lib.servlet.template.decorators.Decorator;

public class WebSiteTemplate
implements Filter {
    public static final String ACTUAL_REQUEST_URI = "scmsActualRequestUri";
    public static final String ACTUAL_REQUEST_DIR = "scmsActualRequestDir";
    public static final String ACTUAL_QUERY_STRING = "scmsActualQueryString";
    public static final String PAGE_DATA = "templatePageData";
    protected FilterConfig filterConfig;
    protected String templateFileName;

    public void init(FilterConfig newConfig) {
        this.filterConfig = newConfig;
        this.templateFileName = this.getServletContext().getInitParameter("templateFileName");
        this.templateFileName = this.templateFileName == null ? "_WebSiteTemplate.jsp" : this.templateFileName;
    }

    private FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    protected ServletContext getServletContext() {
        return this.getFilterConfig().getServletContext();
    }

    public void destroy() {
        this.filterConfig = null;
    }

    protected String getFileName(HttpServletRequest request) {
        return request.getServletPath();
    }

    protected boolean redirectResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return false;
    }

    protected boolean canApplyDecorators(HttpServletRequest request) {
        return true;
    }

    protected void injectAttributes(HttpServletRequest request) throws IOException {
    }

    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        request.setAttribute(ACTUAL_REQUEST_URI, (Object)request.getRequestURI());
        request.setAttribute(ACTUAL_QUERY_STRING, (Object)ServletUtils.encodeUrl(request.getQueryString()));
        int pos = request.getRequestURI().lastIndexOf("/");
        pos = pos >= 0 ? ++pos : request.getRequestURI().length();
        String dir = request.getRequestURI().substring(0, pos);
        request.setAttribute(ACTUAL_REQUEST_DIR, (Object)dir);
        if (this.redirectResponse(request, response)) {
            return;
        }
        CharResponseWrapper wrapper = new CharResponseWrapper(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        String data = wrapper.toString();
        String htmlHead = StringUtils.getTagContents((Object)data, (String)"head", (int)0);
        String htmlTitle = StringUtils.getTagContents((Object)htmlHead, (String)"title", (int)0);
        request.setAttribute(PageAttribute.title, (Object)htmlTitle);
        String htmlBody = StringUtils.getTagContents((Object)data, (String)"body", (int)0);
        if (htmlBody != null) {
            data = htmlBody;
        }
        ArrayList<Decorator> decorators = new ArrayList<Decorator>();
        if (this.canApplyDecorators(request)) {
            decorators.add(new AnchorDecorator());
            decorators.add(new CompressionDecorator());
            for (Decorator decorator : decorators) {
                data = decorator.decorate(data, request, response, chain);
            }
        }
        request.setAttribute(PAGE_DATA, (Object)data);
        this.injectAttributes(request);
        String fileName = this.getFileName(request);
        File parentDir = new File(this.getServletContext().getRealPath(fileName)).getParentFile();
        if (!response.isCommitted()) {
            String templateFileUri = (String)request.getAttribute(PageAttribute.altTemplate);
            if (templateFileUri == null) {
                File templateFile = new File(parentDir, this.templateFileName);
                while (!templateFile.exists()) {
                    if ((parentDir = parentDir.getParentFile()) == null) {
                        throw new ServletException("The template file " + this.templateFileName + " was not found.");
                    }
                    templateFile = new File(parentDir, this.templateFileName);
                }
                templateFileUri = this.toUri(templateFile, this.getServletContext());
            }
            this.getServletContext().getRequestDispatcher(templateFileUri).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String toUri(File file, ServletContext context) {
        String base = context.getRealPath("/");
        String uri = file.getAbsolutePath().substring(base.length() - 1);
        uri = uri.replace('\\', '/');
        return uri;
    }

    private class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter output;

        public String toString() {
            return this.output.toString();
        }

        private CharResponseWrapper(HttpServletResponse response) {
            super(response);
            this.output = new CharArrayWriter();
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.output);
        }
    }
}

