/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.domain.locality;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.tiogasolutions.dev.domain.locality.Province;
import org.tiogasolutions.dev.domain.locality.State;

public enum Country {
    AF("Afghanistan", new Province[0]),
    AX("Aland Islands", new Province[0]),
    AL("Albania", new Province[0]),
    DZ("Algeria", new Province[0]),
    AS("American Samoa", new Province[0]),
    AD("Andorra", new Province[0]),
    AO("Angola", new Province[0]),
    AI("Anguilla", new Province[0]),
    AQ("Antarctica", new Province[0]),
    AG("Antigua and Barbuda", new Province[0]),
    AR("Argentina", new Province[0]),
    AM("Armenia", new Province[0]),
    AW("Aruba", new Province[0]),
    AU("Australia", new Province[0]),
    AT("Austria", new Province[0]),
    AZ("Azerbaijan", new Province[0]),
    BS("Bahamas, The", new Province[0]),
    BH("Bahrain", new Province[0]),
    BD("Bangladesh", new Province[0]),
    BB("Barbados", new Province[0]),
    BY("Belarus", new Province[0]),
    BE("Belgium", new Province[0]),
    BZ("Belize", new Province[0]),
    BJ("Benin", new Province[0]),
    BM("Bermuda", new Province[0]),
    BT("Bhutan", new Province[0]),
    BO("Bolivia", new Province[0]),
    BA("Bosnia and Herzegovina", new Province[0]),
    BW("Botswana", new Province[0]),
    BV("Bouvet Island", new Province[0]),
    BR("Brazil", new Province[0]),
    IO("British Indian Ocean Territory", new Province[0]),
    BN("Brunei Darussalam", new Province[0]),
    BG("Bulgaria", new Province[0]),
    BF("Burkina Faso", new Province[0]),
    BI("Burundi", new Province[0]),
    KH("Cambodia", new Province[0]),
    CM("Cameroon", new Province[0]),
    CA("Canada", new Province[0]),
    CV("Cape Verde", new Province[0]),
    KY("Cayman Islands", new Province[0]),
    CF("Central African Republic", new Province[0]),
    TD("Chad", new Province[0]),
    CL("Chile", new Province[0]),
    CN("China", new Province[0]),
    CX("Christmas Island", new Province[0]),
    CC("Cocos (Keeling) Islands", new Province[0]),
    CO("Colombia", new Province[0]),
    KM("Comoros", new Province[0]),
    CG("Congo", new Province[0]),
    CD("Congo, The Democratic Republic Of The", new Province[0]),
    CK("Cook Islands", new Province[0]),
    CR("Costa Rica", new Province[0]),
    CI("Cote D'ivoire", new Province[0]),
    HR("Croatia", new Province[0]),
    CY("Cyprus", new Province[0]),
    CZ("Czech Republic", new Province[0]),
    DK("Denmark", new Province[0]),
    DJ("Djibouti", new Province[0]),
    DM("Dominica", new Province[0]),
    DO("Dominican Republic", new Province[0]),
    EC("Ecuador", new Province[0]),
    EG("Egypt", new Province[0]),
    SV("El Salvador", new Province[0]),
    GQ("Equatorial Guinea", new Province[0]),
    ER("Eritrea", new Province[0]),
    EE("Estonia", new Province[0]),
    ET("Ethiopia", new Province[0]),
    FK("Falkland Islands (Malvinas)", new Province[0]),
    FO("Faroe Islands", new Province[0]),
    FJ("Fiji", new Province[0]),
    FI("Finland", new Province[0]),
    FR("France", new Province[0]),
    GF("French Guiana", new Province[0]),
    PF("French Polynesia", new Province[0]),
    TF("French Southern Territories", new Province[0]),
    GA("Gabon", new Province[0]),
    GM("Gambia, The", new Province[0]),
    GE("Georgia", new Province[0]),
    DE("Germany", new Province[0]),
    GH("Ghana", new Province[0]),
    GI("Gibraltar", new Province[0]),
    GR("Greece", new Province[0]),
    GL("Greenland", new Province[0]),
    GD("Grenada", new Province[0]),
    GP("Guadeloupe", new Province[0]),
    GU("Guam", new Province[0]),
    GT("Guatemala", new Province[0]),
    GG("Guernsey", new Province[0]),
    GN("Guinea", new Province[0]),
    GW("Guinea-Bissau", new Province[0]),
    GY("Guyana", new Province[0]),
    HT("Haiti", new Province[0]),
    HM("Heard Island and the McDonald Islands", new Province[0]),
    VA("Holy See", new Province[0]),
    HN("Honduras", new Province[0]),
    HK("Hong Kong", new Province[0]),
    HU("Hungary", new Province[0]),
    IS("Iceland", new Province[0]),
    IN("India", new Province[0]),
    ID("Indonesia", new Province[0]),
    IQ("Iraq", new Province[0]),
    IE("Ireland", new Province[0]),
    IM("Isle Of Man", new Province[0]),
    IL("Israel", new Province[0]),
    IT("Italy", new Province[0]),
    JM("Jamaica", new Province[0]),
    JP("Japan", new Province[0]),
    JE("Jersey", new Province[0]),
    JO("Jordan", new Province[0]),
    KZ("Kazakhstan", new Province[0]),
    KE("Kenya", new Province[0]),
    KI("Kiribati", new Province[0]),
    KR("Korea, Republic Of", new Province[0]),
    KW("Kuwait", new Province[0]),
    KG("Kyrgyzstan", new Province[0]),
    LA("Lao People's Democratic Republic", new Province[0]),
    LV("Latvia", new Province[0]),
    LB("Lebanon", new Province[0]),
    LS("Lesotho", new Province[0]),
    LR("Liberia", new Province[0]),
    LY("Libya", new Province[0]),
    LI("Liechtenstein", new Province[0]),
    LT("Lithuania", new Province[0]),
    LU("Luxembourg", new Province[0]),
    MO("Macao", new Province[0]),
    MK("Macedonia, The Former Yugoslav Republic Of", new Province[0]),
    MG("Madagascar", new Province[0]),
    MW("Malawi", new Province[0]),
    MY("Malaysia", new Province[0]),
    MV("Maldives", new Province[0]),
    ML("Mali", new Province[0]),
    MT("Malta", new Province[0]),
    MH("Marshall Islands", new Province[0]),
    MQ("Martinique", new Province[0]),
    MR("Mauritania", new Province[0]),
    MU("Mauritius", new Province[0]),
    YT("Mayotte", new Province[0]),
    MX("Mexico", new Province[0]),
    FM("Micronesia, Federated States Of", new Province[0]),
    MD("Moldova, Republic Of", new Province[0]),
    MC("Monaco", new Province[0]),
    MN("Mongolia", new Province[0]),
    ME("Montenegro", new Province[0]),
    MS("Montserrat", new Province[0]),
    MA("Morocco", new Province[0]),
    MZ("Mozambique", new Province[0]),
    MM("Myanmar", new Province[0]),
    NA("Namibia", new Province[0]),
    NR("Nauru", new Province[0]),
    NP("Nepal", new Province[0]),
    NL("Netherlands", new Province[0]),
    AN("Netherlands Antilles", new Province[0]),
    NC("New Caledonia", new Province[0]),
    NZ("New Zealand", new Province[0]),
    NI("Nicaragua", new Province[0]),
    NE("Niger", new Province[0]),
    NG("Nigeria", new Province[0]),
    NU("Niue", new Province[0]),
    NF("Norfolk Island", new Province[0]),
    MP("Northern Mariana Islands", new Province[0]),
    NO("Norway", new Province[0]),
    OM("Oman", new Province[0]),
    PK("Pakistan", new Province[0]),
    PW("Palau", new Province[0]),
    PS("Palestinian Territories", new Province[0]),
    PA("Panama", new Province[0]),
    PG("Papua New Guinea", new Province[0]),
    PY("Paraguay", new Province[0]),
    PE("Peru", new Province[0]),
    PH("Philippines", new Province[0]),
    PN("Pitcairn", new Province[0]),
    PL("Poland", new Province[0]),
    PT("Portugal", new Province[0]),
    PR("Puerto Rico", new Province[0]),
    QA("Qatar", new Province[0]),
    RE("Reunion", new Province[0]),
    RO("Romania", new Province[0]),
    RU("Russian Federation", new Province[0]),
    RW("Rwanda", new Province[0]),
    BL("Saint Barthelemy", new Province[0]),
    SH("Saint Helena", new Province[0]),
    KN("Saint Kitts and Nevis", new Province[0]),
    LC("Saint Lucia", new Province[0]),
    MF("Saint Martin", new Province[0]),
    PM("Saint Pierre and Miquelon", new Province[0]),
    VC("Saint Vincent and The Grenadines", new Province[0]),
    WS("Samoa", new Province[0]),
    SM("San Marino", new Province[0]),
    ST("Sao Tome and Principe", new Province[0]),
    SA("Saudi Arabia", new Province[0]),
    SN("Senegal", new Province[0]),
    RS("Serbia", new Province[0]),
    SC("Seychelles", new Province[0]),
    SL("Sierra Leone", new Province[0]),
    SG("Singapore", new Province[0]),
    SK("Slovakia", new Province[0]),
    SI("Slovenia", new Province[0]),
    SB("Solomon Islands", new Province[0]),
    SO("Somalia", new Province[0]),
    ZA("South Africa", new Province[0]),
    GS("South Georgia and the South Sandwich Islands", new Province[0]),
    ES("Spain", new Province[0]),
    LK("Sri Lanka", new Province[0]),
    SR("Suriname", new Province[0]),
    SJ("Svalbard and Jan Mayen", new Province[0]),
    SZ("Swaziland", new Province[0]),
    SE("Sweden", new Province[0]),
    CH("Switzerland", new Province[0]),
    TW("Taiwan", new Province[0]),
    TJ("Tajikistan", new Province[0]),
    TZ("Tanzania, United Republic Of", new Province[0]),
    TH("Thailand", new Province[0]),
    TL("Timor-leste", new Province[0]),
    TG("Togo", new Province[0]),
    TK("Tokelau", new Province[0]),
    TO("Tonga", new Province[0]),
    TT("Trinidad and Tobago", new Province[0]),
    TN("Tunisia", new Province[0]),
    TR("Turkey", new Province[0]),
    TM("Turkmenistan", new Province[0]),
    TC("Turks and Caicos Islands", new Province[0]),
    TV("Tuvalu", new Province[0]),
    UG("Uganda", new Province[0]),
    UA("Ukraine", new Province[0]),
    AE("United Arab Emirates", new Province[0]),
    GB("United Kingdom", new Province[0]),
    US("United States of America", State.values()),
    UM("United States Minor Outlying Islands", new Province[0]),
    UY("Uruguay", new Province[0]),
    UZ("Uzbekistan", new Province[0]),
    VU("Vanuatu", new Province[0]),
    VE("Venezuela", new Province[0]),
    VN("Vietnam", new Province[0]),
    VG("Virgin Islands, British", new Province[0]),
    VI("Virgin Islands, U.S.", new Province[0]),
    WF("Wallis and Futuna", new Province[0]),
    EH("Western Sahara", new Province[0]),
    YE("Yemen", new Province[0]),
    ZM("Zambia", new Province[0]),
    ZW("Zimbabwe", new Province[0]);

    private String description;
    private final List<Province> provinces;

    private Country(String description, Province ... provinces) {
        this.description = description;
        List<Province> list = Arrays.asList(provinces);
        this.provinces = Collections.unmodifiableList(list);
    }

    public String getCode() {
        return this.name();
    }

    public String getDescription() {
        return this.description;
    }

    public List<Province> getProvinces() {
        return this.provinces;
    }

    public String toString() {
        return this.description;
    }

    public Province getProvince(State state) {
        return this.getProvince(state == null ? null : state.getAbbreviation());
    }

    public Province getProvince(final String name) {
        if (this.provinces.isEmpty()) {
            return new Province(){

                @Override
                public String getAbbreviation() {
                    return name;
                }

                @Override
                public String getDescription() {
                    return name;
                }
            };
        }
        for (Province province : this.provinces) {
            if (province.getAbbreviation().equalsIgnoreCase(name)) {
                return province;
            }
            if (!province.getDescription().equalsIgnoreCase(name)) continue;
            return province;
        }
        return null;
    }

    public String validate(String state) {
        if (state == null || state.isEmpty()) {
            return null;
        }
        Province province = this.getProvince(state);
        return province == null ? null : province.getAbbreviation();
    }

    public static Country valueOf(String code, Country defaultValue) {
        try {
            return Country.valueOf(code);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

