/*
 * Decompiled with CFR 0.152.
 */
package org.tiogasolutions.dev.common.exceptions;

import org.tiogasolutions.dev.common.exceptions.ApiBadRequestException;
import org.tiogasolutions.dev.common.exceptions.ApiConflictException;
import org.tiogasolutions.dev.common.exceptions.ApiForbiddenException;
import org.tiogasolutions.dev.common.exceptions.ApiImATeapotException;
import org.tiogasolutions.dev.common.exceptions.ApiInternalServerErrorException;
import org.tiogasolutions.dev.common.exceptions.ApiNotFoundException;
import org.tiogasolutions.dev.common.exceptions.ApiNotImplementedException;
import org.tiogasolutions.dev.common.exceptions.ApiPreconditionFailedException;
import org.tiogasolutions.dev.common.exceptions.ApiServiceUnavailableException;
import org.tiogasolutions.dev.common.exceptions.ApiUnauthorizedException;
import org.tiogasolutions.dev.common.exceptions.FineRuntimeException;
import org.tiogasolutions.dev.common.fine.FineMessage;
import org.tiogasolutions.dev.common.fine.FineMessageSet;
import org.tiogasolutions.dev.common.net.HttpStatusCode;

public class ApiException
extends FineRuntimeException {
    private static final long serialVersionUID = 1L;
    private final HttpStatusCode httpStatusCode;

    protected ApiException(HttpStatusCode httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, String message, String ... traits) {
        super(message, traits);
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, Throwable ex, String ... traits) {
        super(ex, traits);
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, String message, Throwable ex, String ... traits) {
        super(message, ex, traits);
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage) {
        super(richMessage);
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, FineMessage richMessage, Throwable ex) {
        super(richMessage, ex, new String[0]);
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet) {
        super(messageSet);
        this.httpStatusCode = httpStatusCode;
    }

    protected ApiException(HttpStatusCode httpStatusCode, FineMessageSet messageSet, Throwable ex) {
        super(messageSet, ex, new String[0]);
        this.httpStatusCode = httpStatusCode;
    }

    public int getStatusCode() {
        return this.httpStatusCode == null ? -1 : this.httpStatusCode.getCode();
    }

    public HttpStatusCode getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public static ApiBadRequestException badRequest() {
        return new ApiBadRequestException();
    }

    public static ApiBadRequestException badRequest(String message, String ... traits) {
        return new ApiBadRequestException(message, traits);
    }

    public static ApiBadRequestException badRequest(Throwable ex, String ... traits) {
        return new ApiBadRequestException(ex, traits);
    }

    public static ApiBadRequestException badRequest(String message, Throwable ex, String ... traits) {
        return new ApiBadRequestException(message, ex, traits);
    }

    public static ApiBadRequestException badRequest(FineMessage richMessage) {
        return new ApiBadRequestException(richMessage);
    }

    public static ApiBadRequestException badRequest(FineMessage richMessage, Throwable ex) {
        return new ApiBadRequestException(richMessage, ex);
    }

    public static ApiBadRequestException badRequest(FineMessageSet messageSet) {
        return new ApiBadRequestException(messageSet);
    }

    public static ApiBadRequestException badRequest(FineMessageSet messageSet, Throwable ex) {
        return new ApiBadRequestException(messageSet, ex);
    }

    public static ApiUnauthorizedException unauthorized() {
        return new ApiUnauthorizedException();
    }

    public static ApiUnauthorizedException unauthorized(String message, String ... traits) {
        return new ApiUnauthorizedException(message, traits);
    }

    public static ApiUnauthorizedException unauthorized(Throwable ex, String ... traits) {
        return new ApiUnauthorizedException(ex, traits);
    }

    public static ApiUnauthorizedException unauthorized(String message, Throwable ex, String ... traits) {
        return new ApiUnauthorizedException(message, ex, traits);
    }

    public static ApiUnauthorizedException unauthorized(FineMessage richMessage) {
        return new ApiUnauthorizedException(richMessage);
    }

    public static ApiUnauthorizedException unauthorized(FineMessage richMessage, Throwable ex) {
        return new ApiUnauthorizedException(richMessage, ex);
    }

    public static ApiUnauthorizedException unauthorized(FineMessageSet messageSet) {
        return new ApiUnauthorizedException(messageSet);
    }

    public static ApiUnauthorizedException unauthorized(FineMessageSet messageSet, Throwable ex) {
        return new ApiUnauthorizedException(messageSet, ex);
    }

    public static ApiForbiddenException forbidden() {
        return new ApiForbiddenException();
    }

    public static ApiForbiddenException forbidden(String message, String ... traits) {
        return new ApiForbiddenException(message, traits);
    }

    public static ApiForbiddenException forbidden(Throwable ex, String ... traits) {
        return new ApiForbiddenException(ex, traits);
    }

    public static ApiForbiddenException forbidden(String message, Throwable ex, String ... traits) {
        return new ApiForbiddenException(message, ex, traits);
    }

    public static ApiForbiddenException forbidden(FineMessage richMessage) {
        return new ApiForbiddenException(richMessage);
    }

    public static ApiForbiddenException forbidden(FineMessage richMessage, Throwable ex) {
        return new ApiForbiddenException(richMessage, ex);
    }

    public static ApiForbiddenException forbidden(FineMessageSet messageSet) {
        return new ApiForbiddenException(messageSet);
    }

    public static ApiForbiddenException forbidden(FineMessageSet messageSet, Throwable ex) {
        return new ApiForbiddenException(messageSet, ex);
    }

    public static ApiNotFoundException notFound() {
        return new ApiNotFoundException();
    }

    public static ApiNotFoundException notFound(String message, String ... traits) {
        return new ApiNotFoundException(message, traits);
    }

    public static ApiNotFoundException notFound(Throwable ex, String ... traits) {
        return new ApiNotFoundException(ex, traits);
    }

    public static ApiNotFoundException notFound(String message, Throwable ex, String ... traits) {
        return new ApiNotFoundException(message, ex, traits);
    }

    public static ApiNotFoundException notFound(FineMessage richMessage) {
        return new ApiNotFoundException(richMessage);
    }

    public static ApiNotFoundException notFound(FineMessage richMessage, Throwable ex) {
        return new ApiNotFoundException(richMessage, ex);
    }

    public static ApiNotFoundException notFound(FineMessageSet messageSet) {
        return new ApiNotFoundException(messageSet);
    }

    public static ApiNotFoundException notFound(FineMessageSet messageSet, Throwable ex) {
        return new ApiNotFoundException(messageSet, ex);
    }

    public static ApiConflictException conflict() {
        return new ApiConflictException();
    }

    public static ApiConflictException conflict(String message, String ... traits) {
        return new ApiConflictException(message, traits);
    }

    public static ApiConflictException conflict(Throwable ex, String ... traits) {
        return new ApiConflictException(ex, traits);
    }

    public static ApiConflictException conflict(String message, Throwable ex, String ... traits) {
        return new ApiConflictException(message, ex, traits);
    }

    public static ApiConflictException conflict(FineMessage richMessage) {
        return new ApiConflictException(richMessage);
    }

    public static ApiConflictException conflict(FineMessage richMessage, Throwable ex) {
        return new ApiConflictException(richMessage, ex);
    }

    public static ApiConflictException conflict(FineMessageSet messageSet) {
        return new ApiConflictException(messageSet);
    }

    public static ApiConflictException conflict(FineMessageSet messageSet, Throwable ex) {
        return new ApiConflictException(messageSet, ex);
    }

    public static ApiPreconditionFailedException preconditionFailed() {
        return new ApiPreconditionFailedException();
    }

    public static ApiPreconditionFailedException preconditionFailed(String message, String ... traits) {
        return new ApiPreconditionFailedException(message, traits);
    }

    public static ApiPreconditionFailedException preconditionFailed(Throwable ex, String ... traits) {
        return new ApiPreconditionFailedException(ex, traits);
    }

    public static ApiPreconditionFailedException preconditionFailed(String message, Throwable ex, String ... traits) {
        return new ApiPreconditionFailedException(message, ex, traits);
    }

    public static ApiPreconditionFailedException preconditionFailed(FineMessage richMessage) {
        return new ApiPreconditionFailedException(richMessage);
    }

    public static ApiPreconditionFailedException preconditionFailed(FineMessage richMessage, Throwable ex) {
        return new ApiPreconditionFailedException(richMessage, ex);
    }

    public static ApiPreconditionFailedException preconditionFailed(FineMessageSet messageSet) {
        return new ApiPreconditionFailedException(messageSet);
    }

    public static ApiPreconditionFailedException preconditionFailed(FineMessageSet messageSet, Throwable ex) {
        return new ApiPreconditionFailedException(messageSet, ex);
    }

    public static ApiImATeapotException imATeapot() {
        return new ApiImATeapotException();
    }

    public static ApiImATeapotException imATeapot(String message, String ... traits) {
        return new ApiImATeapotException(message, traits);
    }

    public static ApiImATeapotException imATeapot(Throwable ex, String ... traits) {
        return new ApiImATeapotException(ex, traits);
    }

    public static ApiImATeapotException imATeapot(String message, Throwable ex, String ... traits) {
        return new ApiImATeapotException(message, ex, traits);
    }

    public static ApiImATeapotException imATeapot(FineMessage richMessage) {
        return new ApiImATeapotException(richMessage);
    }

    public static ApiImATeapotException imATeapot(FineMessage richMessage, Throwable ex) {
        return new ApiImATeapotException(richMessage, ex);
    }

    public static ApiImATeapotException imATeapot(FineMessageSet messageSet) {
        return new ApiImATeapotException(messageSet);
    }

    public static ApiImATeapotException imATeapot(FineMessageSet messageSet, Throwable ex) {
        return new ApiImATeapotException(messageSet, ex);
    }

    public static ApiInternalServerErrorException internalServerError() {
        return new ApiInternalServerErrorException();
    }

    public static ApiInternalServerErrorException internalServerError(String message, String ... traits) {
        return new ApiInternalServerErrorException(message, traits);
    }

    public static ApiInternalServerErrorException internalServerError(Throwable ex, String ... traits) {
        return new ApiInternalServerErrorException(ex, traits);
    }

    public static ApiInternalServerErrorException internalServerError(String message, Throwable ex, String ... traits) {
        return new ApiInternalServerErrorException(message, ex, traits);
    }

    public static ApiInternalServerErrorException internalServerError(FineMessage richMessage) {
        return new ApiInternalServerErrorException(richMessage);
    }

    public static ApiInternalServerErrorException internalServerError(FineMessage richMessage, Throwable ex) {
        return new ApiInternalServerErrorException(richMessage, ex);
    }

    public static ApiInternalServerErrorException internalServerError(FineMessageSet messageSet) {
        return new ApiInternalServerErrorException(messageSet);
    }

    public static ApiInternalServerErrorException internalServerError(FineMessageSet messageSet, Throwable ex) {
        return new ApiInternalServerErrorException(messageSet, ex);
    }

    public static ApiNotImplementedException notImplemented() {
        return new ApiNotImplementedException();
    }

    public static ApiNotImplementedException notImplemented(String message, String ... traits) {
        return new ApiNotImplementedException(message, traits);
    }

    public static ApiNotImplementedException notImplemented(Throwable ex, String ... traits) {
        return new ApiNotImplementedException(ex, traits);
    }

    public static ApiNotImplementedException notImplemented(String message, Throwable ex, String ... traits) {
        return new ApiNotImplementedException(message, ex, traits);
    }

    public static ApiNotImplementedException notImplemented(FineMessage richMessage) {
        return new ApiNotImplementedException(richMessage);
    }

    public static ApiNotImplementedException notImplemented(FineMessage richMessage, Throwable ex) {
        return new ApiNotImplementedException(richMessage, ex);
    }

    public static ApiNotImplementedException notImplemented(FineMessageSet messageSet) {
        return new ApiNotImplementedException(messageSet);
    }

    public static ApiNotImplementedException notImplemented(FineMessageSet messageSet, Throwable ex) {
        return new ApiNotImplementedException(messageSet, ex);
    }

    public static ApiServiceUnavailableException serviceUnavailable() {
        return new ApiServiceUnavailableException();
    }

    public static ApiServiceUnavailableException serviceUnavailable(String message, String ... traits) {
        return new ApiServiceUnavailableException(message, traits);
    }

    public static ApiServiceUnavailableException serviceUnavailable(Throwable ex, String ... traits) {
        return new ApiServiceUnavailableException(ex, traits);
    }

    public static ApiServiceUnavailableException serviceUnavailable(String message, Throwable ex, String ... traits) {
        return new ApiServiceUnavailableException(message, ex, traits);
    }

    public static ApiServiceUnavailableException serviceUnavailable(FineMessage richMessage) {
        return new ApiServiceUnavailableException(richMessage);
    }

    public static ApiServiceUnavailableException serviceUnavailable(FineMessage richMessage, Throwable ex) {
        return new ApiServiceUnavailableException(richMessage, ex);
    }

    public static ApiServiceUnavailableException serviceUnavailable(FineMessageSet messageSet) {
        return new ApiServiceUnavailableException(messageSet);
    }

    public static ApiServiceUnavailableException serviceUnavailable(FineMessageSet messageSet, Throwable ex) {
        return new ApiServiceUnavailableException(messageSet, ex);
    }

    public static ApiException fromCode(int code) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code));
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest();
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized();
            }
            case FORBIDDEN: {
                return ApiException.forbidden();
            }
            case NOT_FOUND: {
                return ApiException.notFound();
            }
            case CONFLICT: {
                return ApiException.conflict();
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed();
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot();
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError();
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented();
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable();
            }
        }
        return new ApiException(httpStatusCode);
    }

    public static ApiException fromCode(int code, String message, String ... traits) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), message, traits);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, String message, String ... traits) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(message, traits);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(message, traits);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(message, traits);
            }
            case NOT_FOUND: {
                return ApiException.notFound(message, traits);
            }
            case CONFLICT: {
                return ApiException.conflict(message, traits);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(message, traits);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(message, traits);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(message, traits);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented(message, traits);
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(message, traits);
            }
        }
        return new ApiException(httpStatusCode, message, traits);
    }

    public static ApiException fromCode(int code, Throwable ex, String ... traits) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), ex, traits);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, Throwable ex, String ... traits) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(ex, traits);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(ex, traits);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(ex, traits);
            }
            case NOT_FOUND: {
                return ApiException.notFound(ex, traits);
            }
            case CONFLICT: {
                return ApiException.conflict(ex, traits);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(ex, traits);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(ex, traits);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(ex, traits);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented(ex, traits);
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(ex, traits);
            }
        }
        return new ApiException(httpStatusCode, ex, traits);
    }

    public static ApiException fromCode(int code, String message, Throwable ex, String ... traits) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), message, ex, traits);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, String message, Throwable ex, String ... traits) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(message, ex, traits);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(message, ex, traits);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(message, ex, traits);
            }
            case NOT_FOUND: {
                return ApiException.notFound(message, ex, traits);
            }
            case CONFLICT: {
                return ApiException.conflict(message, ex, traits);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(message, ex, traits);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(message, ex, traits);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(message, ex, traits);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented(message, ex, traits);
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(message, ex, traits);
            }
        }
        return new ApiException(httpStatusCode, message, ex, traits);
    }

    public static ApiException fromCode(int code, FineMessage richMessage) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), richMessage);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, FineMessage richMessage) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(richMessage);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(richMessage);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(richMessage);
            }
            case NOT_FOUND: {
                return ApiException.notFound(richMessage);
            }
            case CONFLICT: {
                return ApiException.conflict(richMessage);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(richMessage);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(richMessage);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(richMessage);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented(richMessage);
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(richMessage);
            }
        }
        return new ApiException(httpStatusCode, richMessage);
    }

    public static ApiException fromCode(int code, FineMessage richMessage, Throwable ex) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), richMessage, ex);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, FineMessage richMessage, Throwable ex) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(richMessage, ex);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(richMessage, ex);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(richMessage, ex);
            }
            case NOT_FOUND: {
                return ApiException.notFound(richMessage, ex);
            }
            case CONFLICT: {
                return ApiException.conflict(richMessage, ex);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(richMessage, ex);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(richMessage, ex);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(richMessage, ex);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented(richMessage, ex);
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(richMessage, ex);
            }
        }
        return new ApiException(httpStatusCode, richMessage, ex);
    }

    public static ApiException fromCode(int code, FineMessageSet messageSet) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), messageSet);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, FineMessageSet messageSet) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(messageSet);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(messageSet);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(messageSet);
            }
            case NOT_FOUND: {
                return ApiException.notFound(messageSet);
            }
            case CONFLICT: {
                return ApiException.conflict(messageSet);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(messageSet);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(messageSet);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(messageSet);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented();
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(messageSet);
            }
        }
        return new ApiException(httpStatusCode, messageSet);
    }

    public static ApiException fromCode(int code, FineMessageSet messageSet, Throwable ex) {
        return ApiException.fromCode(ApiException.toHttpStatusCode(code), messageSet, ex);
    }

    public static ApiException fromCode(HttpStatusCode httpStatusCode, FineMessageSet messageSet, Throwable ex) {
        switch (httpStatusCode) {
            case BAD_REQUEST: {
                return ApiException.badRequest(messageSet, ex);
            }
            case UNAUTHORIZED: {
                return ApiException.unauthorized(messageSet, ex);
            }
            case FORBIDDEN: {
                return ApiException.forbidden(messageSet, ex);
            }
            case NOT_FOUND: {
                return ApiException.notFound(messageSet, ex);
            }
            case CONFLICT: {
                return ApiException.conflict(messageSet, ex);
            }
            case PRECONDITION_FAILED: {
                return ApiException.preconditionFailed(messageSet, ex);
            }
            case IM_A_TEAPOT: {
                return ApiException.imATeapot(messageSet, ex);
            }
            case INTERNAL_SERVER_ERROR: {
                return ApiException.internalServerError(messageSet, ex);
            }
            case NOT_IMPLEMENTED: {
                return ApiException.notImplemented(messageSet, ex);
            }
            case SERVICE_UNAVAILABLE: {
                return ApiException.serviceUnavailable(messageSet, ex);
            }
        }
        return new ApiException(httpStatusCode, messageSet, ex);
    }

    private static HttpStatusCode toHttpStatusCode(int code) {
        HttpStatusCode httpStatusCode = HttpStatusCode.findByCode(code);
        if (HttpStatusCode.UNDEFINED == httpStatusCode) {
            String msg = String.format("The value %s is not a valid HTTP status code.", code);
            throw new IllegalArgumentException(msg);
        }
        return httpStatusCode;
    }
}

