/*
 * Copyright 2023 Piotr Karlowicz
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */

package org.tinylog.writers.raw;

/**
 * Syslog Facility codes.
 */
public enum SyslogFacility {

	/**
	 * Kernel messages.
	 */
	KERN(0),

	/**
	 * User level messages.
	 */
	USER(1),

	/**
	 * Mail system.
	 */
	MAIL(2),

	/**
	 * System daemons.
	 */
	DAEMON(3),

	/**
	 * Security/Authorization messages.
	 */
	AUTH(4),

	/**
	 * Messages generated by syslogd.
	 */
	SYSLOG(5),

	/**
	 * Line printer subsystem.
	 */
	LPR(6),

	/**
	 * Network news subsystem.
	 */
	NEWS(7),

	/**
	 * UUCP subsystem.
	 */
	UUCP(8),

	/**
	 * Clock daemon.
	 */
	CRON(9),

	/**
	 * Security/Authorization messages.
	 */
	AUTHPRIV(10),

	/**
	 * FTP daemon.
	 */
	FTP(11),

	/**
	 * NTP subsystem.
	 */
	NTP(12),

	/**
	 * Log audit.
	 */
	SECURITY(13),

	/**
	 * Log alert.
	 */
	CONSOLE(14),

	/**
	 * Clock daemon.
	 */
	CLOCK(15),

	/**
	 * Local use 0.
	 */
	LOCAL0(16),

	/**
	 * Local use 1.
	 */
	LOCAL1(17),

	/**
	 * Local use 2.
	 */
	LOCAL2(18),

	/**
	 * Local use 3.
	 */
	LOCAL3(19),

	/**
	 * Local use 4.
	 */
	LOCAL4(20),

	/**
	 * Local use 5.
	 */
	LOCAL5(21),

	/**
	 * Local use 6.
	 */
	LOCAL6(22),

	/**
	 * Local use 7.
	 */
	LOCAL7(23);

	private final int code;

	SyslogFacility(final int code) {
		this.code = code;
	}

	/**
	 * Retrieve the value of the enumeration.
	 * @return The value associated with the enumeration.
	 */
	public int getCode() {
		return this.code;
	}
}
