/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.tinylog.core.LogEntry;
import org.tinylog.writers.AbstractFormatPatternWriter;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class FileWriter
extends AbstractFormatPatternWriter {
    private final Charset charset;
    private final ByteArrayWriter writer;

    public FileWriter() throws FileNotFoundException {
        this(Collections.emptyMap());
    }

    public FileWriter(Map<String, String> properties) throws FileNotFoundException {
        super(properties);
        String fileName = FileWriter.getFileName(properties);
        boolean append = Boolean.parseBoolean(properties.get("append"));
        boolean buffered = Boolean.parseBoolean(properties.get("buffered"));
        boolean writingThread = Boolean.parseBoolean(properties.get("writingthread"));
        this.charset = FileWriter.getCharset(properties);
        this.writer = FileWriter.createByteArrayWriter(fileName, append, buffered, !writingThread, false);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] data = this.render(logEntry).getBytes(this.charset);
        this.writer.write(data, data.length);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

