/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.kotlin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tinylog.Level;
import org.tinylog.Supplier;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.AdvancedMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.kotlin.SupplierUtilsKt;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0018\u001a\u00020\f2\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0010\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J7\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010!J+\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\"J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u001c\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0004J?\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010%J3\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010&J\u0014\u0010'\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0010\u0010'\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J7\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010!J+\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\"J\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u001c\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0016\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0004J?\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010%J3\u0010'\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010&J(\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00032\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0014\u0010)\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0010\u0010)\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J7\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010!J+\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\"J\u000e\u0010)\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u001c\u0010)\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0016\u0010)\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0004J?\u0010)\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010%J3\u0010)\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010&J\u001a\u0010*\u001a\u00020\f2\b\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0006\u0010,\u001a\u00020\fJ\u0006\u0010-\u001a\u00020\fJ\u0006\u0010.\u001a\u00020\fJ\u0006\u0010/\u001a\u00020\fJ\u0006\u00100\u001a\u00020\fJ\u0014\u00101\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0010\u00101\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u000e\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J7\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010!J+\u00101\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\"J\u000e\u00101\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u001c\u00101\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0016\u00101\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0004J?\u00101\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010%J3\u00101\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010&J\u0014\u00102\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0010\u00102\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001J\u000e\u00102\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J7\u00102\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010!J+\u00102\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\"J\u000e\u00102\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$J\u001c\u00102\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00040\u001eJ\u0016\u00102\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u0004J?\u00102\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\"\u0010\u001f\u001a\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e0 \"\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001e\u00a2\u0006\u0002\u0010%J3\u00102\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001d\u001a\u00020\u00042\u0016\u0010\u001f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010 \"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010&R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/tinylog/kotlin/TaggedLogger;", "", "tags", "", "", "(Ljava/util/Set;)V", "debugTags", "errorTags", "formatter", "Lorg/tinylog/format/AdvancedMessageFormatter;", "infoTags", "minimumLevelCoversDebug", "", "minimumLevelCoversError", "minimumLevelCoversInfo", "minimumLevelCoversTrace", "minimumLevelCoversWarn", "provider", "Lorg/tinylog/provider/LoggingProvider;", "kotlin.jvm.PlatformType", "stackTraceDepth", "", "traceTags", "warnTags", "anyEnabled", "level", "Lorg/tinylog/Level;", "debug", "", "message", "Lkotlin/Function0;", "arguments", "", "(Ljava/lang/String;[Lkotlin/jvm/functions/Function0;)V", "(Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/lang/Throwable;Ljava/lang/String;[Lkotlin/jvm/functions/Function0;)V", "(Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "error", "getCoveredTags", "info", "isCoveredByMinimumLevel", "tag", "isDebugEnabled", "isErrorEnabled", "isInfoEnabled", "isTraceEnabled", "isWarnEnabled", "trace", "warn", "tinylog-api-kotlin"})
public final class TaggedLogger {
    private final int stackTraceDepth = 2;
    private final AdvancedMessageFormatter formatter;
    private final LoggingProvider provider;
    private final Set<String> traceTags;
    private final Set<String> debugTags;
    private final Set<String> infoTags;
    private final Set<String> warnTags;
    private final Set<String> errorTags;
    private final boolean minimumLevelCoversTrace;
    private final boolean minimumLevelCoversDebug;
    private final boolean minimumLevelCoversInfo;
    private final boolean minimumLevelCoversWarn;
    private final boolean minimumLevelCoversError;
    private final Set<String> tags;

    public final boolean isTraceEnabled() {
        return this.minimumLevelCoversTrace && this.anyEnabled(this.traceTags, Level.TRACE);
    }

    public final void trace(@Nullable Object message) {
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, null, null, message, new Object[0]);
            }
        }
    }

    public final void trace(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, null, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void trace(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void trace(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, null, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void trace(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, null, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    public final void trace(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, exception, null, null, new Object[0]);
            }
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, exception, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, exception, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void trace(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversTrace) {
            for (String it : this.traceTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.TRACE, exception, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    public final boolean isDebugEnabled() {
        return this.minimumLevelCoversDebug && this.anyEnabled(this.debugTags, Level.DEBUG);
    }

    public final void debug(@Nullable Object message) {
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, null, null, message, new Object[0]);
            }
        }
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, null, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void debug(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void debug(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, null, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void debug(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, null, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    public final void debug(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, exception, null, null, new Object[0]);
            }
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, exception, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, exception, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void debug(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversDebug) {
            for (String it : this.debugTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.DEBUG, exception, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isInfoEnabled() {
        if (!this.minimumLevelCoversInfo) return false;
        Iterable $this$any$iv = this.infoTags;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl = false;
        } while (!this.anyEnabled(this.infoTags, Level.INFO));
        return true;
    }

    public final void info(@Nullable Object message) {
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, null, null, message, new Object[0]);
            }
        }
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, null, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void info(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void info(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, null, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void info(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.INFO, null, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    public final void info(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, exception, null, null, new Object[0]);
            }
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, exception, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                this.provider.log(this.stackTraceDepth, it, Level.INFO, exception, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void info(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversInfo) {
            for (String it : this.infoTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.INFO, exception, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isWarnEnabled() {
        if (!this.minimumLevelCoversWarn) return false;
        Iterable $this$any$iv = this.warnTags;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl = false;
        } while (!this.anyEnabled(this.warnTags, Level.WARN));
        return true;
    }

    public final void warn(@Nullable Object message) {
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, null, null, message, new Object[0]);
            }
        }
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, null, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void warn(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void warn(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, null, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void warn(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.WARN, null, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    public final void warn(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, exception, null, null, new Object[0]);
            }
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, exception, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                this.provider.log(this.stackTraceDepth, it, Level.WARN, exception, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void warn(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversWarn) {
            for (String it : this.warnTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.WARN, exception, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isErrorEnabled() {
        if (!this.minimumLevelCoversError) return false;
        Iterable $this$any$iv = this.errorTags;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl = false;
        } while (!this.anyEnabled(this.errorTags, Level.ERROR));
        return true;
    }

    public final void error(@Nullable Object message) {
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, null, null, message, new Object[0]);
            }
        }
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, null, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void error(@NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, null, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void error(@NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, null, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void error(@NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, null, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    public final void error(@NotNull Throwable exception) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, exception, null, null, new Object[0]);
            }
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, exception, null, (Object)message, new Object[0]);
            }
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull Function0<String> message) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull(message, (String)"message");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, exception, null, SupplierUtilsKt.asSupplier(message), new Object[0]);
            }
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull String message, Object ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)arguments, (String)"arguments");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, exception, (MessageFormatter)this.formatter, (Object)message, Arrays.copyOf(arguments, arguments.length));
            }
        }
    }

    public final void error(@NotNull Throwable exception, @NotNull String message, Function0<? extends Object> ... arguments) {
        Intrinsics.checkParameterIsNotNull((Object)exception, (String)"exception");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull(arguments, (String)"arguments");
        if (this.minimumLevelCoversError) {
            for (String it : this.errorTags) {
                Supplier<? extends Object>[] supplierArray = SupplierUtilsKt.asSuppliers(arguments);
                this.provider.log(this.stackTraceDepth, it, Level.ERROR, exception, (MessageFormatter)this.formatter, (Object)message, (Object[])Arrays.copyOf(supplierArray, supplierArray.length));
            }
        }
    }

    private final boolean anyEnabled(Set<String> tags2, Level level) {
        for (String it : tags2) {
            if (!this.provider.isEnabled(this.stackTraceDepth + 1, it, level)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getCoveredTags(Set<String> tags2, Level level) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = tags2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isCoveredByMinimumLevel(it, level)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
    }

    private final boolean isCoveredByMinimumLevel(String tag, Level level) {
        return this.provider.getMinimumLevel(tag).ordinal() <= level.ordinal();
    }

    public TaggedLogger(@NotNull Set<String> tags2) {
        Intrinsics.checkParameterIsNotNull(tags2, (String)"tags");
        this.tags = tags2;
        this.stackTraceDepth = 2;
        this.formatter = new AdvancedMessageFormatter(Configuration.getLocale(), Configuration.isEscapingEnabled());
        this.provider = ProviderRegistry.getLoggingProvider();
        this.traceTags = this.getCoveredTags(this.tags, Level.TRACE);
        this.debugTags = this.getCoveredTags(this.tags, Level.DEBUG);
        this.infoTags = this.getCoveredTags(this.tags, Level.INFO);
        this.warnTags = this.getCoveredTags(this.tags, Level.WARN);
        this.errorTags = this.getCoveredTags(this.tags, Level.ERROR);
        Collection collection = this.traceTags;
        boolean bl = false;
        this.minimumLevelCoversTrace = !collection.isEmpty();
        collection = this.debugTags;
        bl = false;
        this.minimumLevelCoversDebug = !collection.isEmpty();
        collection = this.infoTags;
        bl = false;
        this.minimumLevelCoversInfo = !collection.isEmpty();
        collection = this.warnTags;
        bl = false;
        this.minimumLevelCoversWarn = !collection.isEmpty();
        collection = this.errorTags;
        bl = false;
        this.minimumLevelCoversError = !collection.isEmpty();
    }
}

