/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import org.apache.log4j.Category;
import org.apache.log4j.LogManager;
import org.apache.log4j.spi.LoggerFactory;
import org.tinylog.Level;

public class Logger
extends Category {
    private static final boolean MINIMUM_LEVEL_COVERS_TRACE = Logger.isCoveredByMinimumLevel(Level.TRACE);

    Logger(Logger parent, String name) {
        super(parent, name);
    }

    protected Logger(String name) {
        super(LogManager.getParentLogger(name), name);
    }

    public static Logger getLogger(String name) {
        return LogManager.getLogger(name);
    }

    public static Logger getLogger(Class clazz) {
        return LogManager.getLogger(clazz.getName());
    }

    public static Logger getRootLogger() {
        return LogManager.getRootLogger();
    }

    public static Logger getLogger(String name, LoggerFactory factory) {
        return LogManager.getLogger(name, factory);
    }

    public void trace(Object message) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, message, (Object[])null);
        }
    }

    public void trace(Object message, Throwable t) {
        if (MINIMUM_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, t, null, message == t ? null : message, (Object[])null);
        }
    }

    public boolean isTraceEnabled() {
        return MINIMUM_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }
}

