/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.serviceplugin.processor.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.cepcore.impl.AbstractEventProcessor;
import org.tinygroup.context.Context;
import org.tinygroup.context.util.ContextFactory;
import org.tinygroup.event.Event;
import org.tinygroup.event.Parameter;
import org.tinygroup.event.ServiceInfo;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.service.Service;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.service.registry.ServiceRegistryItem;
import org.tinygroup.serviceplugin.ServicePlugin;
import org.tinygroup.serviceplugin.processor.ServiceProcessor;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProcessorImpl
extends AbstractEventProcessor
implements ServiceProcessor {
    private static Logger logger = LoggerFactory.getLogger(ServicePlugin.class);
    private List<ServiceProviderInterface> providers = new ArrayList<ServiceProviderInterface>();
    private List<ServiceInfo> infos = new ArrayList<ServiceInfo>();

    public void process(Event event) {
        String serviceId = event.getServiceRequest().getServiceId();
        String version = event.getServiceRequest().getVersion();
        Service service = null;
        ServiceProviderInterface serviceProvider = null;
        for (ServiceProviderInterface provider : this.providers) {
            service = this.notNull(version) ? provider.getService(serviceId, version) : provider.getService(serviceId);
            if (service == null) continue;
            serviceProvider = provider;
            break;
        }
        if (serviceProvider == null) {
            String serviceName = event.getServiceRequest().getName();
            String groupId = event.getServiceRequest().getGroupId();
            String artId = event.getServiceRequest().getArtifactId();
            for (ServiceProviderInterface provider : this.providers) {
                service = this.notNull(version) ? provider.getService(groupId, artId, serviceName, version) : provider.getService(groupId, artId, serviceName);
                if (service == null) continue;
                serviceProvider = provider;
                break;
            }
        }
        if (service != null) {
            serviceProvider.execute(service, event.getServiceRequest().getContext());
            ServiceRegistryItem item = serviceProvider.getServiceRegistryItem(service);
            Context oldC = event.getServiceRequest().getContext();
            Context c = ContextFactory.getContext();
            for (Parameter p : item.getResults()) {
                String name = p.getName();
                c.put(name, oldC.get(name));
            }
            event.getServiceRequest().setContext(c);
        } else {
            logger.logMessage(LogLevel.ERROR, "\u672a\u627e\u5230\u5408\u9002\u7684Service[id:{0},version:{1}]", new Object[]{serviceId, version});
        }
    }

    public void setCepCore(CEPCore cepCore) {
    }

    @Override
    public void addServiceProvider(ServiceProviderInterface provider) {
        this.providers.add(provider);
        Collection collection = provider.getServiceRegistory().getServiceRegistryItems();
        if (collection != null) {
            for (ServiceRegistryItem item : collection) {
                if (this.infos.contains(item)) continue;
                this.infos.add((ServiceInfo)item);
            }
        }
    }

    private boolean notNull(String str) {
        return null != str && !"".equals(str);
    }

    public List<ServiceInfo> getServiceInfos() {
        return this.infos;
    }

    @Override
    public void setConfig(XmlNode config) {
    }
}

