/**
 *  Copyright (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  Licensed under the GPL, Version 3.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.gnu.org/licenses/gpl.html
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 * --------------------------------------------------------------------------
 *  版权 (c) 1997-2013, tinygroup.org (luo_guo@live.cn).
 *
 *  本开源软件遵循 GPL 3.0 协议;
 *  如果您不遵循此协议，则不被允许使用此文件。
 *  你可以从下面的地址获取完整的协议文本
 *
 *       http://www.gnu.org/licenses/gpl.html
 */
package org.tinygroup.serviceplugin;

import java.util.Iterator;
import java.util.Map;
import java.util.Map.Entry;

import org.tinygroup.cepcore.CEPCore;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.plugin.PluginManager;
import org.tinygroup.plugin.config.PluginService;
import org.tinygroup.plugin.impl.BasePlugin;
import org.tinygroup.service.ServiceProviderInterface;
import org.tinygroup.serviceplugin.processor.ServiceProcessor;
import org.tinygroup.serviceplugin.processor.impl.ServiceProcessorImpl;
import org.tinygroup.springutil.SpringUtil;
import org.tinygroup.xmlparser.node.XmlNode;

public class ServicePlugin extends BasePlugin {
	private static Logger logger = LoggerFactory.getLogger(ServicePlugin.class);
	private CEPCore cepcore;
	private ServiceProcessor processor;
//	private String initResourcePath;
//	private ClassLoader initLoader;

	public void init() {
		super.init();
		XmlNode config = getXmlNodeConfig();
//		initAopManager(config);
		initProcessors(config);
//		initResource();
	}

	public void start() {
		logger.logMessage(LogLevel.DEBUG, "启动ServicePlugin");
		cepcore.registerEventProcessor(processor);
		logger.logMessage(LogLevel.DEBUG, "启动ServicePlugin完成");
	}

	protected ClassLoader getThisClassLoader() {
		return this.getClass().getClassLoader();
	}
//	private void initAopManager(XmlNode config) {
//		ServiceAopManager.getInstance().setConfig(config);
//	}

	private void initProcessors(XmlNode config) {
		logger.logMessage(LogLevel.DEBUG, "初始化ServiceProcessor");
		processor = new ServiceProcessorImpl();
		processor.setConfig(config);

		Map<PluginService, Object> map = super.getServiceInstanceMap();
		Iterator<Entry<PluginService, Object>> iterator = map.entrySet()
				.iterator();
		while (iterator.hasNext()) {
			Entry<PluginService, Object> entry = iterator.next();
			dealExecutor(entry);
		}
		logger.logMessage(LogLevel.DEBUG, "初始化ServiceProcessor完成");
	}

//	private void initResource() {
//		// XmlNode node = getXmlNodeConfig();
//		// if (node == null)
//		// return;
//		// NameFilter<XmlNode> nameFilter = new NameFilter<XmlNode>(node);
//		// XmlNode resourcePathNode = nameFilter.findNode("ResourcePath");
//		// String str = resourcePathNode.getAttribute("value");
//		// this.initResourcePath = str;
//
//		// loadInitResourcePath();
//
//	}

	private void dealExecutor(Entry<PluginService, Object> entry) {
		ServiceProviderInterface provider = (ServiceProviderInterface) entry
				.getValue();
		PluginService service = entry.getKey();
		logger.logMessage(LogLevel.DEBUG,
				"处理ServicePlugin的Service[id:{0},version:{1}]", service.getId(),
				service.getVersion());
		processor.addServiceProvider(provider);
		logger.logMessage(LogLevel.DEBUG,
				"处理ServicePlugin的Service[id:{0},version:{1}]完成",
				service.getId(), service.getVersion());

	}

	public void pause() {
		logger.logMessage(LogLevel.DEBUG, "暂停ServicePlugin");
		cepcore.unregisterEventProcessor(processor);
		logger.logMessage(LogLevel.DEBUG, "暂停ServicePlugin完成");
	}

	public void stop() {
		logger.logMessage(LogLevel.DEBUG, "停止ServicePlugin");
		cepcore.unregisterEventProcessor(processor);
		logger.logMessage(LogLevel.DEBUG, "停止ServicePlugin完成");
	}

	public void destroy() {
		logger.logMessage(LogLevel.DEBUG, "销毁ServicePlugin");
		super.destroy();
		// removeInitResourcePath();
		logger.logMessage(LogLevel.DEBUG, "销毁ServicePlugin完成");
	}

	public <T> void setService(T service, Class<T> clazz) {

		if (CEPCore.class.isAssignableFrom(clazz)) {
			if (service == null) {
				this.cepcore = null;
			} else {
				this.cepcore = (CEPCore) service;
			}
		}
	}

	private XmlNode getXmlNodeConfig() {
		PluginManager pluginManager = SpringUtil.getBean(
				"pluginManager");
		XmlNode config = pluginManager.getConifg(getPluginInfo());
		return config;
	}

//	private void removeInitResourcePath() {
//		if (this.initResourcePath != null) {
//
//			URL[] urls = new URL[1];
//			FileObject file = VFS.resolveFile(initResourcePath);
//			urls[0] = file.getURL();
//			PluginResourceFactory.getManager().deResolve(getPluginInfo(), urls,
//					initLoader);
//			PluginManager pluginManager = SpringUtil.getBean(
//					"pluginManager");
//			pluginManager.deResolveResource(initLoader, urls);
//		}
//	}
//
//	private void loadInitResourcePath() {
//		if (this.initResourcePath == null || "".equals(this.initResourcePath))
//			return;
//		URL[] urls = new URL[1];
//		FileObject file = VFS.resolveFile(this.initResourcePath);
//		urls[0] = file.getURL();
//		List<URL> listurl = new ArrayList<URL>();
//		for (FileObject o : file.getChildren()) {
//			if (o.getFileName().endsWith(".jar")) {
//				listurl.add(o.getURL());
//			}
//		}
//		URL[] urlArray = new URL[listurl.size()];
//		int i = 0;
//		for (URL u : listurl) {
//			urlArray[i] = u;
//			i++;
//		}
//		initLoader = new URLClassLoader(urlArray, getThisClassLoader());
//		LoaderManagerFactory.getManager().addLoader(initLoader);// 注册loader
//		PluginManager pluginManager = SpringUtil.getBean(
//				"pluginManager");
//		pluginManager.resolveResource(initLoader, urlArray);
//		PluginResourceFactory.getManager().resolve(getPluginInfo(), urlArray,
//				initLoader);
//
//	}
}
