/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xstream;

import com.thoughtworks.xstream.XStream;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.xstream.config.XStreamConfiguration;

public final class XStreamFactory {
    private static Map<String, XStream> xstreamMap = new HashMap<String, XStream>();

    private XStreamFactory() {
    }

    public static XStream getXStream() {
        return XStreamFactory.getXStream("");
    }

    public static XStream getXStream(String key) {
        XStream xstream;
        String xstreamKey = key;
        if (key == null) {
            xstreamKey = "";
        }
        if ((xstream = xstreamMap.get(xstreamKey)) == null) {
            xstream = XStreamFactory.newXStream(null);
            xstreamMap.put(xstreamKey, xstream);
        }
        return xstream;
    }

    public static XStream getXStream(String key, ClassLoader classLoader) {
        XStream xstream;
        String xstreamKey = key;
        if (key == null) {
            xstreamKey = "";
        }
        if ((xstream = xstreamMap.get(xstreamKey)) == null) {
            xstream = XStreamFactory.newXStream(classLoader);
            xstreamMap.put(xstreamKey, xstream);
        }
        return xstream;
    }

    private static XStream newXStream(ClassLoader classLoader) {
        XStream xstream = new XStream();
        if (classLoader != null) {
            xstream.setClassLoader(classLoader);
        } else {
            xstream.setClassLoader(XStreamFactory.class.getClassLoader());
        }
        xstream.autodetectAnnotations(true);
        xstream.setMode(1001);
        xstream.processAnnotations(XStreamConfiguration.class);
        return xstream;
    }
}

