/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.xmlparser.document;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.tinygroup.xmlparser.XmlDocument;
import org.tinygroup.xmlparser.node.XmlNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDocumentImpl
implements XmlDocument {
    private XmlNode root = null;
    private XmlNode xmlDeclaration = null;
    private List<XmlNode> commentList = null;
    private List<XmlNode> doctypeList = null;
    private List<XmlNode> processingInstructionList = null;

    public XmlNode getRoot() {
        return this.root;
    }

    public void setRoot(XmlNode root) {
        this.root = root;
    }

    @Override
    public XmlNode getXmlDeclaration() {
        return this.xmlDeclaration;
    }

    @Override
    public void setXmlDeclaration(XmlNode xmlDeclaration) {
        this.xmlDeclaration = xmlDeclaration;
    }

    @Override
    public List<XmlNode> getCommentList() {
        return this.commentList;
    }

    @Override
    public List<XmlNode> getDoctypeList() {
        return this.doctypeList;
    }

    @Override
    public List<XmlNode> getProcessingInstructionList() {
        return this.processingInstructionList;
    }

    @Override
    public void addDoctype(XmlNode node) {
        if (this.doctypeList == null) {
            this.doctypeList = new ArrayList<XmlNode>();
        }
        this.doctypeList.add(node);
    }

    @Override
    public void addProcessingInstruction(XmlNode node) {
        if (this.processingInstructionList == null) {
            this.processingInstructionList = new ArrayList<XmlNode>();
        }
        this.processingInstructionList.add(node);
    }

    @Override
    public void addComment(XmlNode node) {
        if (this.commentList == null) {
            this.commentList = new ArrayList<XmlNode>();
        }
        this.commentList.add(node);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.xmlDeclaration != null) {
            sb.append(this.xmlDeclaration.toStringBuffer());
        }
        if (this.commentList != null) {
            for (XmlNode n : this.commentList) {
                sb.append(n.toStringBuffer());
            }
        }
        if (this.doctypeList != null) {
            for (XmlNode n : this.doctypeList) {
                sb.append(n.toStringBuffer());
            }
        }
        if (this.processingInstructionList != null) {
            for (XmlNode n : this.processingInstructionList) {
                sb.append(n.toStringBuffer());
            }
        }
        sb.append(this.root.toStringBuffer());
        return sb.toString();
    }

    public void write(OutputStream out) throws IOException {
        if (this.xmlDeclaration != null) {
            this.xmlDeclaration.write(out);
        }
        if (this.commentList != null) {
            for (XmlNode n : this.commentList) {
                n.write(out);
            }
        }
        if (this.doctypeList != null) {
            for (XmlNode n : this.doctypeList) {
                n.write(out);
            }
        }
        if (this.processingInstructionList != null) {
            for (XmlNode n : this.processingInstructionList) {
                n.write(out);
            }
        }
        this.root.write(out);
    }
}

