/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.parser.formater;

import java.io.IOException;
import java.io.OutputStream;
import org.tinygroup.parser.Document;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.NodeFormater;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NodeFormaterImpl<T extends Document<N>, N extends Node<N>>
implements NodeFormater<N, T> {
    private String indentString = "  ";
    static final String NEWLINE = "\r\n";
    private String encode = "UTF-8";

    public String getEncode() {
        return this.encode;
    }

    @Override
    public void setEncode(String encode) {
        this.encode = encode;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public String getIndentString(int tab) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < tab; ++i) {
            sb.append(this.indentString);
        }
        return sb.toString();
    }

    public void setIndentString(String indentString) {
        if (indentString != null) {
            this.indentString = indentString;
        }
    }

    protected abstract StringBuffer formatDocumentSelf(T var1);

    protected abstract void formatDocumentSelf(T var1, OutputStream var2) throws IOException;

    protected void formatNode(StringBuffer sb, N node, int tab) {
        String is = this.getIndentString(tab);
        sb.append(is);
        node.getHeader(sb);
        if (node.getNodeType().isHasContent() && node.getContent() != null) {
            sb.append(node.getContent());
        } else if (node.getSubNodes() != null) {
            if (node.getSubNodes().size() == 1 && ((Node)node.getSubNodes().get(0)).getNodeType().isHasContent()) {
                sb.append(((Node)node.getSubNodes().get(0)).getContent().trim());
            } else {
                if (node.getNodeName() != null) {
                    sb.append(NEWLINE);
                }
                for (Node n : node.getSubNodes()) {
                    this.formatNode(sb, n, node.getNodeName() != null ? tab + 1 : tab);
                }
                sb.append(is);
            }
        }
        node.getFooter(sb);
        if (node.getNodeName() != null || node.getNodeType().getHead().getStart() != null) {
            sb.append(NEWLINE);
        }
    }

    protected void formatNode(N node, OutputStream out, int tab) throws IOException {
        String is = this.getIndentString(tab);
        out.write(is.getBytes(this.encode));
        StringBuffer sb = new StringBuffer();
        node.getHeader(sb);
        out.write(sb.toString().getBytes(this.encode));
        if (node.getNodeType().isHasContent() && node.getContent() != null) {
            out.write(node.getContent().getBytes(this.encode));
        } else if (node.getSubNodes() != null) {
            if (node.getSubNodes().size() == 1 && ((Node)node.getSubNodes().get(0)).getNodeType().isHasContent()) {
                out.write(((Node)node.getSubNodes().get(0)).getContent().trim().getBytes(this.encode));
            } else {
                out.write(NEWLINE.getBytes(this.encode));
                for (Node n : node.getSubNodes()) {
                    this.formatNode(n, out, tab + 1);
                }
                out.write(is.getBytes(this.encode));
            }
        }
        sb = new StringBuffer();
        node.getFooter(sb);
        out.write(sb.toString().getBytes(this.encode));
        out.write(NEWLINE.getBytes(this.encode));
    }

    @Override
    public String format(N node) {
        StringBuffer sb = new StringBuffer();
        this.formatNode(sb, node, 0);
        return sb.toString();
    }

    @Override
    public String format(T doc) {
        StringBuffer sb = new StringBuffer();
        this.formatDocumentSelf(doc);
        this.formatNode(sb, doc.getRoot(), 0);
        return sb.toString();
    }

    @Override
    public void format(N node, OutputStream out) throws IOException {
        this.formatNode(node, out, 0);
    }

    @Override
    public void format(T doc, OutputStream out) throws IOException {
        this.formatDocumentSelf(doc, out);
        this.formatNode(doc.getRoot(), out, 0);
    }
}

