/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache.ehcache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sf.ehcache.Element;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.CacheManager;
import org.tinygroup.cache.exception.CacheException;

public class EhCache
implements Cache {
    private static final String GROUP_MAP = "group_map";
    private CacheManager cacheManager;
    private net.sf.ehcache.CacheManager manager = net.sf.ehcache.CacheManager.getInstance();
    private net.sf.ehcache.Cache cache;

    private String getKey(String group, String key) {
        return String.format("%s:%s", group, key);
    }

    public void init(String region) {
        this.cache = (net.sf.ehcache.Cache)this.manager.addCacheIfAbsent(region);
    }

    public Object get(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        Object value = element != null ? element.getObjectValue() : null;
        return value;
    }

    public void put(String key, Object object) {
        Element element = new Element((Object)key, object);
        this.cache.put(element);
    }

    public void putSafe(String key, Object object) {
        if (this.cache.get((Serializable)((Object)key)) != null) {
            throw new CacheException("key:" + key + "\u5df2\u5b58\u5728\u7f13\u5b58\u4e2d");
        }
        Element element = new Element((Object)key, object);
        this.cache.put(element);
    }

    public void put(String groupName, String key, Object object) {
        Element element = this.cache.get((Serializable)((Object)GROUP_MAP));
        Map groupMap = null;
        groupMap = element == null ? new ConcurrentHashMap() : (Map)element.getObjectValue();
        CopyOnWriteArraySet<String> keysSet = (CopyOnWriteArraySet<String>)groupMap.get(groupName);
        if (keysSet == null) {
            keysSet = new CopyOnWriteArraySet<String>();
            groupMap.put(groupName, keysSet);
        }
        keysSet.add(key);
        this.put(this.getKey(groupName, key), object);
        this.put(GROUP_MAP, groupMap);
    }

    public Object get(String groupName, String key) {
        return this.get(this.getKey(groupName, key));
    }

    public Set<String> getGroupKeys(String group) {
        Element element = this.cache.get((Serializable)((Object)GROUP_MAP));
        if (element == null) {
            return null;
        }
        Map groupMap = (Map)element.getObjectValue();
        return (Set)groupMap.get(group);
    }

    public void cleanGroup(String group) {
        Set<String> groupKeys = this.getGroupKeys(group);
        if (groupKeys != null) {
            for (String key : groupKeys) {
                this.remove(group, key);
            }
        }
    }

    public void clear() {
        this.cache.removeAll();
    }

    public void remove(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    public void remove(String group, String key) {
        Set<String> groupKeys = this.getGroupKeys(group);
        if (groupKeys != null) {
            this.cache.remove((Serializable)((Object)this.getKey(group, key)));
        }
    }

    public String getStats() {
        return this.cache.getStatistics().toString();
    }

    public int freeMemoryElements(int numberToFree) {
        throw new CacheException("ehcache does not support this feature.");
    }

    public void destroy() {
        this.cacheManager.removeCache((Cache)this);
    }

    public void setCacheManager(CacheManager manager) {
        this.cacheManager = manager;
    }

    public Object[] get(String[] keys) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                objs.add(this.get(keys[i]));
            }
        }
        return objs.toArray();
    }

    public Object[] get(String group, String[] keys) {
        ArrayList<Object> objs = new ArrayList<Object>();
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                objs.add(this.get(group, keys[i]));
            }
        }
        return objs.toArray();
    }

    public void remove(String[] keys) {
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                this.remove(keys[i]);
            }
        }
    }

    public void remove(String group, String[] keys) {
        if (keys != null && keys.length > 0) {
            for (int i = 0; i < keys.length; ++i) {
                this.remove(group, keys[i]);
            }
        }
    }
}

