/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.cache;

import junit.framework.TestCase;
import org.tinygroup.beancontainer.BeanContainerFactory;
import org.tinygroup.cache.Cache;
import org.tinygroup.cache.exception.CacheException;
import org.tinygroup.fileresolver.FileProcessor;
import org.tinygroup.fileresolver.FileResolver;
import org.tinygroup.fileresolver.FileResolverFactory;
import org.tinygroup.fileresolver.FileResolverUtil;
import org.tinygroup.fileresolver.impl.I18nFileProcessor;
import org.tinygroup.fileresolver.impl.XStreamFileProcessor;
import org.tinygroup.springutil.SpringBeanContainer;
import org.tinygroup.springutil.fileresolver.SpringBeansFileProcessor;

public class CacheTest
extends TestCase {
    Cache cache;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = (Cache)BeanContainerFactory.getBeanContainer((ClassLoader)((Object)((Object)this)).getClass().getClassLoader()).getBean("ehCache");
        this.cache.init("DC");
        this.cache.clear();
    }

    public void testGetString() throws CacheException {
        this.cache.put("aa", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("aa"));
    }

    public void testPutSafe() {
        try {
            this.cache.putSafe("aa", (Object)123);
            this.cache.putSafe("aa", (Object)"bb");
            CacheTest.fail();
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
    }

    public void testPutStringStringObject() throws CacheException {
        this.cache.put("group", "aa", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("group", "aa"));
    }

    public void testGetGroupKeys() throws CacheException {
        this.cache.put("groupa", "aa1", (Object)"123");
        this.cache.put("groupa", "aa2", (Object)"123");
        this.cache.put("groupa", "aa3", (Object)"123");
        CacheTest.assertEquals((int)3, (int)this.cache.getGroupKeys("groupa").size());
    }

    public void testCleanGroup() throws CacheException {
        this.cache.put("bb", (Object)"123");
        this.cache.put("group", "aa1", (Object)"123");
        this.cache.put("group", "aa2", (Object)"123");
        this.cache.put("group", "aa3", (Object)"123");
        this.cache.cleanGroup("group");
        this.cache.get("group", "aa1");
    }

    public void testClear() throws CacheException {
        this.cache.put("bb", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("bb"));
        this.cache.clear();
        this.cache.get("bb");
    }

    public void testRemoveStringString() throws CacheException {
        this.cache.put("group", "bb", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("group", "bb"));
        this.cache.remove("group", "bb");
        this.cache.get("group", "bb");
    }

    public void testRemove() throws CacheException {
        this.cache.put("bb", (Object)"123");
        CacheTest.assertEquals((Object)"123", (Object)this.cache.get("bb"));
        this.cache.remove("bb");
        this.cache.get("bb");
    }

    public void testGetStats() {
        System.out.println(System.getProperty("user.dir"));
        System.out.println(this.cache.getStats());
    }

    public void testFreeMemoryElements() throws CacheException {
        this.cache.put("aa", (Object)"aa");
        for (int i = 0; i < 100; ++i) {
            this.cache.put("aa" + i, (Object)i);
        }
        for (int j = 0; j < 500; ++j) {
            this.cache.get("aa");
        }
        try {
            this.cache.freeMemoryElements(100);
            CacheTest.assertEquals((Object)"aa", (Object)this.cache.get("aa"));
            this.cache.get("aa1");
            CacheTest.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGetStrings() throws CacheException {
        this.cache.put("aa", (Object)"123");
        this.cache.put("bb", (Object)"456");
        CacheTest.assertEquals((int)2, (int)this.cache.get(new String[]{"aa", "bb"}).length);
    }

    public void testGetGroupStrings() throws CacheException {
        this.cache.put("group", "aa", (Object)"111");
        this.cache.put("group", "bb", (Object)"222");
        this.cache.put("group1", "cc", (Object)"333");
        this.cache.put("group1", "dd", (Object)"444");
        CacheTest.assertEquals((int)2, (int)this.cache.get("group", new String[]{"aa", "bb"}).length);
        CacheTest.assertEquals((int)2, (int)this.cache.get("group1", new String[]{"cc", "dd"}).length);
    }

    public void testRemoveStrings() throws CacheException {
        this.cache.put("aa", (Object)"111");
        this.cache.put("bb", (Object)"222");
        this.cache.remove(new String[]{"aa", "bb"});
        CacheTest.assertNull((Object)this.cache.get(new String[]{"aa", "bb"})[0]);
        CacheTest.assertNull((Object)this.cache.get(new String[]{"aa", "bb"})[1]);
    }

    public void testRemoveGroupStrings() throws CacheException {
        this.cache.put("group", "aa", (Object)"111");
        this.cache.put("group", "bb", (Object)"222");
        this.cache.put("group1", "cc", (Object)"333");
        this.cache.put("group1", "dd", (Object)"444");
        this.cache.remove("group", new String[]{"aa", "bb"});
        CacheTest.assertNull((Object)this.cache.get("group", new String[]{"aa", "bb"})[0]);
        CacheTest.assertNull((Object)this.cache.get("group", new String[]{"aa", "bb"})[1]);
    }

    static {
        BeanContainerFactory.initBeanContainer((String)SpringBeanContainer.class.getName());
        FileResolver fileResolver = FileResolverFactory.getFileResolver();
        FileResolverUtil.addClassPathPattern((FileResolver)fileResolver);
        fileResolver.addResolvePath(FileResolverUtil.getClassPath((FileResolver)fileResolver));
        fileResolver.addResolvePath(FileResolverUtil.getWebClasses());
        try {
            fileResolver.addResolvePath(FileResolverUtil.getWebLibJars((FileResolver)fileResolver));
        }
        catch (Exception exception) {
            // empty catch block
        }
        fileResolver.addIncludePathPattern("org\\.tinygroup\\.(.)*\\.jar");
        fileResolver.addFileProcessor((FileProcessor)new XStreamFileProcessor());
        fileResolver.addFileProcessor((FileProcessor)new I18nFileProcessor());
        fileResolver.addFileProcessor((FileProcessor)new SpringBeansFileProcessor());
        fileResolver.resolve();
    }
}

