/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.context.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.tinygroup.context.BaseContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseContextImpl
implements BaseContext,
Serializable {
    private static final long serialVersionUID = -2965722554039526665L;
    private Map<String, Object> itemMap = new HashMap<String, Object>();

    public void setItemMap(Map<String, Object> itemMap) {
        this.itemMap = itemMap;
    }

    @Override
    public <T> T put(String name, T object) {
        return (T)this.itemMap.put(name, object);
    }

    @Override
    public <T> T remove(String name) {
        return (T)this.itemMap.remove(name);
    }

    @Override
    public <T> T get(String name) {
        return (T)this.itemMap.get(name);
    }

    @Override
    public void putAll(Map<String, Object> map) {
        this.itemMap.putAll(map);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        Object result = this.itemMap.get(name);
        if (result == null) {
            result = defaultValue;
        }
        return (T)result;
    }

    @Override
    public boolean exist(String name) {
        return this.itemMap.containsKey(name);
    }

    @Override
    public BaseContext contain(String name) {
        if (this.itemMap.containsKey(name)) {
            return this;
        }
        return null;
    }

    @Override
    public void clear() {
        this.itemMap.clear();
    }

    @Override
    public Map<String, Object> getItemMap() {
        return this.itemMap;
    }

    @Override
    public int size() {
        return this.itemMap.size();
    }

    @Override
    public boolean renameKey(String key, String newKey) {
        if (this.itemMap.containsKey(key)) {
            this.itemMap.put(newKey, this.itemMap.get(key));
            this.itemMap.remove(key);
            return true;
        }
        return false;
    }
}

