/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.tinygroup.commons.i18n.LocaleUtil;
import org.tinygroup.commons.tools.Entities;
import org.tinygroup.commons.tools.StringUtil;

public class StringEscapeUtil {
    private static final BitSet ALPHA;
    private static final BitSet ALPHANUM;
    private static final BitSet MARK;
    private static final BitSet RESERVED;
    private static final BitSet UNRESERVED;
    private static char[] HEXADECIMAL;

    public static String escapeJava(String str) {
        return StringEscapeUtil.escapeJavaStyleString(str, false, false);
    }

    public static String escapeJava(String str, boolean strict) {
        return StringEscapeUtil.escapeJavaStyleString(str, false, strict);
    }

    public static void escapeJava(String str, Appendable out) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, false, out, false);
    }

    public static void escapeJava(String str, Appendable out, boolean strict) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, false, out, strict);
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtil.escapeJavaStyleString(str, true, false);
    }

    public static String escapeJavaScript(String str, boolean strict) {
        return StringEscapeUtil.escapeJavaStyleString(str, true, strict);
    }

    public static void escapeJavaScript(String str, Appendable out) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, true, out, false);
    }

    public static void escapeJavaScript(String str, Appendable out, boolean strict) throws IOException {
        StringEscapeUtil.escapeJavaStyleString(str, true, out, strict);
    }

    private static String escapeJavaStyleString(String str, boolean javascript, boolean strict) {
        if (str == null) {
            return null;
        }
        try {
            StringBuilder out = new StringBuilder(str.length() * 2);
            if (StringEscapeUtil.escapeJavaStyleString(str, javascript, out, strict)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean escapeJavaStyleString(String str, boolean javascript, Appendable out, boolean strict) throws IOException {
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        int length = str.length();
        block12: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch < ' ') {
                switch (ch) {
                    case '\b': {
                        out.append('\\');
                        out.append('b');
                        break;
                    }
                    case '\n': {
                        out.append('\\');
                        out.append('n');
                        break;
                    }
                    case '\t': {
                        out.append('\\');
                        out.append('t');
                        break;
                    }
                    case '\f': {
                        out.append('\\');
                        out.append('f');
                        break;
                    }
                    case '\r': {
                        out.append('\\');
                        out.append('r');
                        break;
                    }
                    default: {
                        if (ch > '\u000f') {
                            out.append("\\u00" + Integer.toHexString(ch).toUpperCase());
                            break;
                        }
                        out.append("\\u000" + Integer.toHexString(ch).toUpperCase());
                    }
                }
                needToChange = true;
                continue;
            }
            if (strict && ch > '\u00ff') {
                if (ch > '\u0fff') {
                    out.append("\\u").append(Integer.toHexString(ch).toUpperCase());
                } else {
                    out.append("\\u0").append(Integer.toHexString(ch).toUpperCase());
                }
                needToChange = true;
                continue;
            }
            switch (ch) {
                case '\'': 
                case '/': {
                    if (javascript) {
                        out.append('\\');
                        needToChange = true;
                    }
                    out.append(ch);
                    continue block12;
                }
                case '\"': {
                    out.append('\\');
                    out.append('\"');
                    needToChange = true;
                    continue block12;
                }
                case '\\': {
                    out.append('\\');
                    out.append('\\');
                    needToChange = true;
                    continue block12;
                }
                default: {
                    out.append(ch);
                }
            }
        }
        return needToChange;
    }

    public static String unescapeJava(String str) {
        return StringEscapeUtil.unescapeJavaStyleString(str);
    }

    public static void unescapeJava(String str, Appendable out) throws IOException {
        StringEscapeUtil.unescapeJavaStyleString(str, out);
    }

    public static String unescapeJavaScript(String str) {
        return StringEscapeUtil.unescapeJavaStyleString(str);
    }

    public static void unescapeJavaScript(String str, Appendable out) throws IOException {
        StringEscapeUtil.unescapeJavaStyleString(str, out);
    }

    private static String unescapeJavaStyleString(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringBuilder out = new StringBuilder(str.length());
            if (StringEscapeUtil.unescapeJavaStyleString(str, out)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean unescapeJavaStyleString(String str, Appendable out) throws IOException {
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        int length = str.length();
        StringBuilder unicode = new StringBuilder(4);
        boolean hadSlash = false;
        boolean inUnicode = false;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() != 4) continue;
                String unicodeStr = unicode.toString();
                try {
                    int value = Integer.parseInt(unicodeStr, 16);
                    out.append((char)value);
                    unicode.setLength(0);
                    inUnicode = false;
                    hadSlash = false;
                    needToChange = true;
                }
                catch (NumberFormatException e) {
                    out.append("\\u" + unicodeStr);
                }
                continue;
            }
            if (hadSlash) {
                hadSlash = false;
                switch (ch) {
                    case '\\': {
                        out.append('\\');
                        needToChange = true;
                        break;
                    }
                    case '\'': {
                        out.append('\'');
                        needToChange = true;
                        break;
                    }
                    case '\"': {
                        out.append('\"');
                        needToChange = true;
                        break;
                    }
                    case 'r': {
                        out.append('\r');
                        needToChange = true;
                        break;
                    }
                    case 'f': {
                        out.append('\f');
                        needToChange = true;
                        break;
                    }
                    case 't': {
                        out.append('\t');
                        needToChange = true;
                        break;
                    }
                    case 'n': {
                        out.append('\n');
                        needToChange = true;
                        break;
                    }
                    case 'b': {
                        out.append('\b');
                        needToChange = true;
                        break;
                    }
                    case 'u': {
                        inUnicode = true;
                        break;
                    }
                    default: {
                        out.append(ch);
                        break;
                    }
                }
                continue;
            }
            if (ch == '\\') {
                hadSlash = true;
                continue;
            }
            out.append(ch);
        }
        if (hadSlash) {
            out.append('\\');
        }
        return needToChange;
    }

    public static String escapeHtml(String str) {
        return StringEscapeUtil.escapeEntities(Entities.HTML40_MODIFIED, str);
    }

    public static void escapeHtml(String str, Appendable out) throws IOException {
        StringEscapeUtil.escapeEntities(Entities.HTML40_MODIFIED, str, out);
    }

    public static String escapeXml(String str) {
        return StringEscapeUtil.escapeEntities(Entities.XML, str);
    }

    public static void escapeXml(String str, Appendable out) throws IOException {
        StringEscapeUtil.escapeEntities(Entities.XML, str, out);
    }

    public static String escapeEntities(Entities entities, String str) {
        if (str == null) {
            return null;
        }
        try {
            StringBuilder out = new StringBuilder(str.length());
            if (StringEscapeUtil.escapeEntitiesInternal(entities, str, out)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    public static void escapeEntities(Entities entities, String str, Appendable out) throws IOException {
        StringEscapeUtil.escapeEntitiesInternal(entities, str, out);
    }

    public static String unescapeHtml(String str) {
        return StringEscapeUtil.unescapeEntities(Entities.HTML40, str);
    }

    public static void unescapeHtml(String str, Appendable out) throws IOException {
        StringEscapeUtil.unescapeEntities(Entities.HTML40, str, out);
    }

    public static String unescapeXml(String str) {
        return StringEscapeUtil.unescapeEntities(Entities.XML, str);
    }

    public static void unescapeXml(String str, Appendable out) throws IOException {
        StringEscapeUtil.unescapeEntities(Entities.XML, str, out);
    }

    public static String unescapeEntities(Entities entities, String str) {
        if (str == null) {
            return null;
        }
        try {
            StringBuilder out = new StringBuilder(str.length());
            if (StringEscapeUtil.unescapeEntitiesInternal(entities, str, out)) {
                return out.toString();
            }
            return str;
        }
        catch (IOException e) {
            return str;
        }
    }

    public static void unescapeEntities(Entities entities, String str, Appendable out) throws IOException {
        StringEscapeUtil.unescapeEntitiesInternal(entities, str, out);
    }

    private static boolean escapeEntitiesInternal(Entities entities, String str, Appendable out) throws IOException {
        boolean needToChange = false;
        if (entities == null) {
            throw new IllegalArgumentException("The Entities must not be null");
        }
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            String entityName = entities.getEntityName(ch);
            if (entityName == null) {
                out.append(ch);
                continue;
            }
            out.append('&');
            out.append(entityName);
            out.append(';');
            needToChange = true;
        }
        return needToChange;
    }

    private static boolean unescapeEntitiesInternal(Entities entities, String str, Appendable out) throws IOException {
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '&') {
                int semi;
                block14: {
                    semi = str.indexOf(59, i + 1);
                    if (semi == -1 || i + 1 >= semi - 1) {
                        out.append(ch);
                        continue;
                    }
                    if (str.charAt(i + 1) == '#') {
                        int firstCharIndex = i + 2;
                        int radix = 10;
                        if (firstCharIndex >= semi - 1) {
                            out.append(ch);
                            out.append('#');
                            ++i;
                            continue;
                        }
                        char firstChar = str.charAt(firstCharIndex);
                        if (firstChar == 'x' || firstChar == 'X') {
                            radix = 16;
                            if (++firstCharIndex >= semi - 1) {
                                out.append(ch);
                                out.append('#');
                                ++i;
                                continue;
                            }
                        }
                        try {
                            int entityValue = Integer.parseInt(str.substring(firstCharIndex, semi), radix);
                            out.append((char)entityValue);
                            needToChange = true;
                            break block14;
                        }
                        catch (NumberFormatException e) {
                            out.append(ch);
                            out.append('#');
                            ++i;
                            continue;
                        }
                    }
                    String entityName = str.substring(i + 1, semi);
                    int entityValue = -1;
                    if (entities != null) {
                        entityValue = entities.getEntityValue(entityName);
                    }
                    if (entityValue == -1) {
                        out.append('&');
                        out.append(entityName);
                        out.append(';');
                    } else {
                        out.append((char)entityValue);
                        needToChange = true;
                    }
                }
                i = semi;
                continue;
            }
            out.append(ch);
        }
        return needToChange;
    }

    public static String escapeSql(String str) {
        return StringUtil.replace(str, "'", "''");
    }

    public static void escapeSql(String str, Appendable out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        String result = StringUtil.replace(str, "'", "''");
        if (result != null) {
            out.append(result);
        }
    }

    public static String escapeURL(String str) {
        try {
            return StringEscapeUtil.escapeURLInternal(str, null, true);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String escapeURL(String str, String encoding) throws UnsupportedEncodingException {
        return StringEscapeUtil.escapeURLInternal(str, encoding, true);
    }

    public static String escapeURL(String str, String encoding, boolean strict) throws UnsupportedEncodingException {
        return StringEscapeUtil.escapeURLInternal(str, encoding, strict);
    }

    public static void escapeURL(String str, String encoding, Appendable out) throws IOException {
        StringEscapeUtil.escapeURLInternal(str, encoding, out, true);
    }

    public static void escapeURL(String str, String encoding, Appendable out, boolean strict) throws IOException {
        StringEscapeUtil.escapeURLInternal(str, encoding, out, strict);
    }

    private static String escapeURLInternal(String str, String encoding, boolean strict) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        try {
            StringBuilder out = new StringBuilder(64);
            if (StringEscapeUtil.escapeURLInternal(str, encoding, out, strict)) {
                return out.toString();
            }
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean escapeURLInternal(String str, String encoding, Appendable out, boolean strict) throws IOException {
        if (encoding == null) {
            encoding = LocaleUtil.getContext().getCharset().name();
        }
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        if (str == null) {
            return needToChange;
        }
        for (char ch : str.toCharArray()) {
            byte[] bytes;
            if (StringEscapeUtil.isSafeCharacter(ch, strict)) {
                out.append(ch);
                continue;
            }
            if (ch == ' ') {
                out.append('+');
                needToChange = true;
                continue;
            }
            for (byte toEscape : bytes = String.valueOf(ch).getBytes(encoding)) {
                out.append('%');
                int low = toEscape & 0xF;
                int high = (toEscape & 0xF0) >> 4;
                out.append(HEXADECIMAL[high]);
                out.append(HEXADECIMAL[low]);
            }
            needToChange = true;
        }
        return needToChange;
    }

    private static boolean isSafeCharacter(int ch, boolean strict) {
        if (strict) {
            return UNRESERVED.get(ch);
        }
        return ch > 32 && !RESERVED.get(ch) && !Character.isWhitespace((char)ch);
    }

    public static String unescapeURL(String str) {
        try {
            return StringEscapeUtil.unescapeURLInternal(str, null);
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String unescapeURL(String str, String encoding) throws UnsupportedEncodingException {
        return StringEscapeUtil.unescapeURLInternal(str, encoding);
    }

    public static void unescapeURL(String str, String encoding, Appendable out) throws IOException {
        StringEscapeUtil.unescapeURLInternal(str, encoding, out);
    }

    private static String unescapeURLInternal(String str, String encoding) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        try {
            StringBuilder out = new StringBuilder(str.length());
            if (StringEscapeUtil.unescapeURLInternal(str, encoding, out)) {
                return out.toString();
            }
            return str;
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (IOException e) {
            return str;
        }
    }

    private static boolean unescapeURLInternal(String str, String encoding, Appendable out) throws IOException {
        if (encoding == null) {
            encoding = LocaleUtil.getContext().getCharset().name();
        }
        boolean needToChange = false;
        if (out == null) {
            throw new IllegalArgumentException("The Appendable must not be null");
        }
        byte[] buffer = null;
        int pos = 0;
        int startIndex = 0;
        char[] charArray = str.toCharArray();
        int length = charArray.length;
        for (int i = 0; i < length; ++i) {
            char ch = charArray[i];
            if (ch < '\u0100') {
                if (buffer == null) {
                    buffer = new byte[length - i];
                }
                if (pos == 0) {
                    startIndex = i;
                }
                switch (ch) {
                    case '+': {
                        buffer[pos++] = 32;
                        needToChange = true;
                        break;
                    }
                    case '%': {
                        if (i + 2 < length) {
                            try {
                                byte b = (byte)Integer.parseInt(str.substring(i + 1, i + 3), 16);
                                buffer[pos++] = b;
                                i += 2;
                                needToChange = true;
                            }
                            catch (NumberFormatException e) {
                                buffer[pos++] = (byte)ch;
                            }
                            break;
                        }
                        buffer[pos++] = (byte)ch;
                        break;
                    }
                    default: {
                        buffer[pos++] = (byte)ch;
                        break;
                    }
                }
                continue;
            }
            if (pos > 0) {
                String s = new String(buffer, 0, pos, encoding);
                out.append(s);
                if (!needToChange && !s.equals(new String(charArray, startIndex, pos))) {
                    needToChange = true;
                }
                pos = 0;
            }
            out.append(ch);
        }
        if (pos > 0) {
            String s = new String(buffer, 0, pos, encoding);
            out.append(s);
            if (!needToChange && !s.equals(new String(charArray, startIndex, pos))) {
                needToChange = true;
            }
            pos = 0;
        }
        return needToChange;
    }

    static {
        int i;
        ALPHA = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            ALPHA.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            ALPHA.set(i);
        }
        ALPHANUM = new BitSet(256);
        ALPHANUM.or(ALPHA);
        for (i = 48; i <= 57; ++i) {
            ALPHANUM.set(i);
        }
        MARK = new BitSet(256);
        MARK.set(45);
        MARK.set(95);
        MARK.set(46);
        MARK.set(33);
        MARK.set(126);
        MARK.set(42);
        MARK.set(39);
        MARK.set(40);
        MARK.set(41);
        RESERVED = new BitSet(256);
        RESERVED.set(59);
        RESERVED.set(47);
        RESERVED.set(63);
        RESERVED.set(58);
        RESERVED.set(64);
        RESERVED.set(38);
        RESERVED.set(61);
        RESERVED.set(43);
        RESERVED.set(36);
        RESERVED.set(44);
        UNRESERVED = new BitSet(256);
        UNRESERVED.or(ALPHANUM);
        UNRESERVED.or(MARK);
        HEXADECIMAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

