/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.ArrayUtil;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.Substitution;
import org.tinygroup.commons.tools.ToStringBuilder;

public class MatchResultSubstitution
extends Substitution {
    public static final MatchResult EMPTY_MATCH_RESULT = MatchResultSubstitution.createEmptyMatchResult();
    private final MatchResult[] results;

    private static MatchResult createEmptyMatchResult() {
        Matcher matcher = Pattern.compile("^$").matcher("");
        Assert.assertTrue(matcher.find());
        return matcher.toMatchResult();
    }

    public MatchResultSubstitution() {
        this("$", EMPTY_MATCH_RESULT);
    }

    public MatchResultSubstitution(MatchResult result) {
        this("$", result);
    }

    public void setMatchResult(MatchResult result) {
        if (this.results.length != 1) {
            new IllegalArgumentException("expected " + this.results.length + " MatchResults");
        }
        this.results[0] = result;
    }

    public void setMatchResults(MatchResult ... results) {
        Assert.assertTrue(!ArrayUtil.isEmptyArray(results), "results", new Object[0]);
        if (this.results.length != results.length) {
            throw new IllegalArgumentException("expected " + this.results.length + " MatchResults");
        }
        for (int i = 0; i < results.length; ++i) {
            this.results[i] = results[i];
        }
    }

    public MatchResultSubstitution(String replacementPrefixes, MatchResult ... results) {
        super(replacementPrefixes);
        this.results = new MatchResult[this.replacementPrefixes.length()];
        this.setMatchResults(results);
    }

    public MatchResult getMatch() {
        return this.getMatch(0);
    }

    public MatchResult getMatch(int index) {
        return this.results[index];
    }

    protected String group(int index, int groupNumber) {
        MatchResult result = this.getMatch(index);
        if (groupNumber <= result.groupCount()) {
            return result.group(groupNumber);
        }
        return null;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        for (int i = 0; i < this.replacementPrefixes.length(); ++i) {
            mb.append(this.replacementPrefixes.charAt(i) + "n", this.results[i]);
        }
        return new ToStringBuilder().append(this.getClass().getSimpleName()).append(mb).toString();
    }
}

