/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.tinygroup.commons.tools.CollectionUtil;

public class HashCodeUtil {
    private static ThreadLocal registry = new ThreadLocal(){

        protected Object initialValue() {
            return new HashSet();
        }
    };

    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object) {
        return HashCodeBuilder.reflectionHashCode((int)initialNonZeroOddNumber, (int)multiplierNonZeroOddNumber, (Object)object);
    }

    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object, boolean testTransients) {
        return HashCodeBuilder.reflectionHashCode((int)initialNonZeroOddNumber, (int)multiplierNonZeroOddNumber, (Object)object, (boolean)testTransients);
    }

    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object, boolean testTransients, Class reflectUpToClass) {
        return HashCodeBuilder.reflectionHashCode((int)initialNonZeroOddNumber, (int)multiplierNonZeroOddNumber, (Object)object, (boolean)testTransients, (Class)reflectUpToClass);
    }

    public static int reflectionHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object, boolean testTransients, Class reflectUpToClass, String[] excludeFields) {
        return HashCodeBuilder.reflectionHashCode((int)initialNonZeroOddNumber, (int)multiplierNonZeroOddNumber, (Object)object, (boolean)testTransients, (Class)reflectUpToClass, (String[])excludeFields);
    }

    public static int reflectionHashCode(Object object) {
        return HashCodeBuilder.reflectionHashCode((Object)object);
    }

    public static int reflectionHashCode(Object object, boolean testTransients) {
        return HashCodeBuilder.reflectionHashCode((Object)object, (boolean)testTransients);
    }

    public static int reflectionHashCode(Object object, String[] excludeFields) {
        return HashCodeBuilder.reflectionHashCode((Object)object, (String[])excludeFields);
    }

    public static int reflectionHashCode(Object object, Collection excludeFields) {
        return HashCodeBuilder.reflectionHashCode((Object)object, (Collection)excludeFields);
    }

    public static int reflectionCompareHashCode(Object object, String[] compareFields) {
        return HashCodeUtil.reflectionCompareHashCode(17, 37, object, false, null, compareFields);
    }

    public static int reflectionCompareHashCode(Object object, Collection compareFields) {
        return HashCodeUtil.reflectionCompareHashCode(17, 37, object, false, null, CollectionUtil.toNoNullStringArray(compareFields));
    }

    public static int reflectionCompareHashCode(int initialNonZeroOddNumber, int multiplierNonZeroOddNumber, Object object, boolean testTransients, Class reflectUpToClass, String[] excludeFields) {
        Class<?> clazz;
        if (object == null) {
            throw new IllegalArgumentException("The object to build a hash code for must not be null");
        }
        HashCodeBuilder builder = new HashCodeBuilder(initialNonZeroOddNumber, multiplierNonZeroOddNumber);
        HashCodeUtil.reflectionAppend(object, clazz, builder, testTransients, excludeFields);
        for (clazz = object.getClass(); clazz.getSuperclass() != null && clazz != reflectUpToClass; clazz = clazz.getSuperclass()) {
            HashCodeUtil.reflectionAppend(object, clazz, builder, testTransients, excludeFields);
        }
        return builder.toHashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reflectionAppend(Object object, Class clazz, HashCodeBuilder builder, boolean useTransients, String[] excludeFields) {
        if (HashCodeUtil.isRegistered(object)) {
            return;
        }
        try {
            HashCodeUtil.register(object);
            AccessibleObject[] fields = clazz.getDeclaredFields();
            List<String> excludedFieldList = excludeFields != null ? Arrays.asList(excludeFields) : Collections.EMPTY_LIST;
            AccessibleObject.setAccessible(fields, true);
            for (int i = 0; i < fields.length; ++i) {
                AccessibleObject field = fields[i];
                if (excludedFieldList.contains(((Field)field).getName()) || ((Field)field).getName().indexOf(36) != -1 || !useTransients && Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                try {
                    Object fieldValue = ((Field)field).get(object);
                    builder.append(fieldValue);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new InternalError("Unexpected IllegalAccessException");
                }
            }
        }
        finally {
            HashCodeUtil.unregister(object);
        }
    }

    static boolean isRegistered(Object value) {
        return HashCodeUtil.getRegistry().contains(HashCodeUtil.toIdentityHashCodeInteger(value));
    }

    static Set getRegistry() {
        return (Set)registry.get();
    }

    static void unregister(Object value) {
        HashCodeUtil.getRegistry().remove(HashCodeUtil.toIdentityHashCodeInteger(value));
    }

    static void register(Object value) {
        HashCodeUtil.getRegistry().add(HashCodeUtil.toIdentityHashCodeInteger(value));
    }

    private static Integer toIdentityHashCodeInteger(Object value) {
        return new Integer(System.identityHashCode(value));
    }
}

