/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtil {
    public static <T> ArrayList<T> createArrayList() {
        return new ArrayList();
    }

    public static <T> ArrayList<T> createArrayList(int initialCapacity) {
        return new ArrayList(initialCapacity);
    }

    public static <T> ArrayList<T> createArrayList(Iterable<? extends T> c) {
        ArrayList list;
        if (c instanceof Collection) {
            list = new ArrayList((Collection)c);
        } else {
            list = new ArrayList();
            CollectionUtil.iterableToCollection(c, list);
            list.trimToSize();
        }
        return list;
    }

    public static <T, V extends T> ArrayList<T> createArrayList(V ... args) {
        if (args == null || args.length == 0) {
            return new ArrayList();
        }
        ArrayList<V> list = new ArrayList<V>(args.length);
        for (V v : args) {
            list.add(v);
        }
        return list;
    }

    public static <T> LinkedList<T> createLinkedList() {
        return new LinkedList();
    }

    public static <T> LinkedList<T> createLinkedList(Iterable<? extends T> c) {
        LinkedList list = new LinkedList();
        CollectionUtil.iterableToCollection(c, list);
        return list;
    }

    public static <T, V extends T> LinkedList<T> createLinkedList(V ... args) {
        LinkedList<V> list = new LinkedList<V>();
        if (args != null) {
            for (V v : args) {
                list.add(v);
            }
        }
        return list;
    }

    public static <T> List<T> asList(T ... args) {
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.asList(args);
    }

    public static <K, V> HashMap<K, V> createHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> createHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> createLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    public static <K, V> TreeMap<K, V> createTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> createTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    public static <K, V> ConcurrentHashMap<K, V> createConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    public static <T> HashSet<T> createHashSet() {
        return new HashSet();
    }

    public static <T, V extends T> HashSet<T> createHashSet(V ... args) {
        if (args == null || args.length == 0) {
            return new HashSet();
        }
        HashSet<V> set = new HashSet<V>(args.length);
        for (V v : args) {
            set.add(v);
        }
        return set;
    }

    public static <T> HashSet<T> createHashSet(Iterable<? extends T> c) {
        HashSet set;
        if (c instanceof Collection) {
            set = new HashSet((Collection)c);
        } else {
            set = new HashSet();
            CollectionUtil.iterableToCollection(c, set);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> createLinkedHashSet() {
        return new LinkedHashSet();
    }

    public static <T, V extends T> LinkedHashSet<T> createLinkedHashSet(V ... args) {
        if (args == null || args.length == 0) {
            return new LinkedHashSet();
        }
        LinkedHashSet<V> set = new LinkedHashSet<V>(args.length);
        for (V v : args) {
            set.add(v);
        }
        return set;
    }

    public static <T> LinkedHashSet<T> createLinkedHashSet(Iterable<? extends T> c) {
        LinkedHashSet set;
        if (c instanceof Collection) {
            set = new LinkedHashSet((Collection)c);
        } else {
            set = new LinkedHashSet();
            CollectionUtil.iterableToCollection(c, set);
        }
        return set;
    }

    public static <T> TreeSet<T> createTreeSet() {
        return new TreeSet();
    }

    public static <T, V extends T> TreeSet<T> createTreeSet(V ... args) {
        return CollectionUtil.createTreeSet(null, args);
    }

    public static <T> TreeSet<T> createTreeSet(Iterable<? extends T> c) {
        return CollectionUtil.createTreeSet(null, c);
    }

    public static <T> TreeSet<T> createTreeSet(Comparator<? super T> comparator) {
        return new TreeSet<T>(comparator);
    }

    public static <T, V extends T> TreeSet<T> createTreeSet(Comparator<? super T> comparator, V ... args) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        if (args != null) {
            for (V v : args) {
                set.add(v);
            }
        }
        return set;
    }

    public static <T> TreeSet<T> createTreeSet(Comparator<? super T> comparator, Iterable<? extends T> c) {
        TreeSet<? super T> set = new TreeSet<T>(comparator);
        CollectionUtil.iterableToCollection(c, set);
        return set;
    }

    private static <T> void iterableToCollection(Iterable<? extends T> c, Collection<T> list) {
        for (T element : c) {
            list.add(element);
        }
    }

    public static boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static String[] toNoNullStringArray(Collection collection) {
        if (collection == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return CollectionUtil.toNoNullStringArray(collection.toArray());
    }

    static String[] toNoNullStringArray(Object[] array) {
        ArrayList<String> list = new ArrayList<String>(array.length);
        for (int i = 0; i < array.length; ++i) {
            Object e = array[i];
            if (e == null) continue;
            list.add(e.toString());
        }
        return list.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static Map extractToMap(Collection collection, String keyPropertyName, String valuePropertyName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        HashMap<Object, Object> map = new HashMap<Object, Object>(collection.size());
        for (Object obj : collection) {
            map.put(PropertyUtils.getProperty(obj, (String)keyPropertyName), PropertyUtils.getProperty(obj, (String)valuePropertyName));
        }
        return map;
    }

    public static Map extractIndexToMap(Collection collection, String keyPropertyName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        HashMap map = new HashMap(collection.size());
        for (Object obj : collection) {
            map.put(PropertyUtils.getProperty(obj, (String)keyPropertyName), obj);
        }
        return map;
    }

    public static List extractToList(Collection collection, String propertyName) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        ArrayList<Object> list = new ArrayList<Object>(collection.size());
        for (Object obj : collection) {
            list.add(PropertyUtils.getProperty(obj, (String)propertyName));
        }
        return list;
    }

    public static String extractToString(Collection collection, String propertyName, String separator) throws IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        List list = CollectionUtil.extractToList(collection, propertyName);
        return StringUtils.join((Collection)list, (String)separator);
    }

    public static String convertToString(Collection collection, String separator) {
        return StringUtils.join((Collection)collection, (String)separator);
    }

    public static String convertToString(Collection collection, String prefix, String postfix) {
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            builder.append(prefix).append(o).append(postfix);
        }
        return builder.toString();
    }

    public static <T> T getFirst(Collection<T> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        return collection.iterator().next();
    }

    public static <T> T getLast(Collection<T> collection) {
        T current;
        if (CollectionUtil.isEmpty(collection)) {
            return null;
        }
        if (collection instanceof List) {
            List list = (List)collection;
            return (T)list.get(list.size() - 1);
        }
        Iterator<T> iterator = collection.iterator();
        do {
            current = iterator.next();
        } while (iterator.hasNext());
        return current;
    }

    public static <T> List<T> union(Collection<T> a, Collection<T> b) {
        ArrayList<T> result = new ArrayList<T>(a);
        result.addAll(b);
        return result;
    }

    public static <T> List<T> subtract(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>(a);
        for (T element : b) {
            list.remove(element);
        }
        return list;
    }

    public static <T> List<T> intersection(Collection<T> a, Collection<T> b) {
        ArrayList<T> list = new ArrayList<T>();
        for (T element : a) {
            if (!b.contains(element)) continue;
            list.add(element);
        }
        return list;
    }
}

