/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.tools;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.tools.Assert;
import org.tinygroup.commons.tools.ClassUtil;
import org.tinygroup.commons.tools.GenericTypeResolver;
import org.tinygroup.commons.tools.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BridgeMethodResolver {
    public static Method findBridgedMethod(Method bridgeMethod) {
        Method[] methods;
        if (bridgeMethod == null || !bridgeMethod.isBridge()) {
            return bridgeMethod;
        }
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        for (Method candidateMethod : methods = ReflectionUtils.getAllDeclaredMethods(bridgeMethod.getDeclaringClass())) {
            if (!BridgeMethodResolver.isBridgedCandidateFor(candidateMethod, bridgeMethod)) continue;
            candidateMethods.add(candidateMethod);
        }
        if (candidateMethods.size() == 1) {
            return (Method)candidateMethods.get(0);
        }
        Method bridgedMethod = BridgeMethodResolver.searchCandidates(candidateMethods, bridgeMethod);
        if (bridgedMethod != null) {
            return bridgedMethod;
        }
        return bridgeMethod;
    }

    private static Method searchCandidates(List<Method> candidateMethods, Method bridgeMethod) {
        if (candidateMethods.isEmpty()) {
            return null;
        }
        Map<TypeVariable, Type> typeParameterMap = GenericTypeResolver.getTypeVariableMap(bridgeMethod.getDeclaringClass());
        Method previousMethod = null;
        boolean sameSig = true;
        for (Method candidateMethod : candidateMethods) {
            if (BridgeMethodResolver.isBridgeMethodFor(bridgeMethod, candidateMethod, typeParameterMap)) {
                return candidateMethod;
            }
            if (previousMethod != null) {
                sameSig = sameSig && Arrays.equals(candidateMethod.getGenericParameterTypes(), previousMethod.getGenericParameterTypes());
            }
            previousMethod = candidateMethod;
        }
        return sameSig ? candidateMethods.get(0) : null;
    }

    private static boolean isBridgedCandidateFor(Method candidateMethod, Method bridgeMethod) {
        return !candidateMethod.isBridge() && !candidateMethod.equals(bridgeMethod) && candidateMethod.getName().equals(bridgeMethod.getName()) && candidateMethod.getParameterTypes().length == bridgeMethod.getParameterTypes().length;
    }

    static boolean isBridgeMethodFor(Method bridgeMethod, Method candidateMethod, Map<TypeVariable, Type> typeVariableMap) {
        if (BridgeMethodResolver.isResolvedTypeMatch(candidateMethod, bridgeMethod, typeVariableMap)) {
            return true;
        }
        Method method = BridgeMethodResolver.findGenericDeclaration(bridgeMethod);
        return method != null && BridgeMethodResolver.isResolvedTypeMatch(method, candidateMethod, typeVariableMap);
    }

    private static Method findGenericDeclaration(Method bridgeMethod) {
        Class<?>[] interfaces;
        Class<?> superclass = bridgeMethod.getDeclaringClass().getSuperclass();
        while (!Object.class.equals(superclass)) {
            Method method = BridgeMethodResolver.searchForMatch(superclass, bridgeMethod);
            if (method != null && !method.isBridge()) {
                return method;
            }
            superclass = superclass.getSuperclass();
        }
        for (Class<?> ifc : interfaces = ClassUtil.getAllInterfacesForClass(bridgeMethod.getDeclaringClass())) {
            Method method = BridgeMethodResolver.searchForMatch(ifc, bridgeMethod);
            if (method == null || method.isBridge()) continue;
            return method;
        }
        return null;
    }

    private static boolean isResolvedTypeMatch(Method genericMethod, Method candidateMethod, Map<TypeVariable, Type> typeVariableMap) {
        Class<?>[] candidateParameters;
        Type[] genericParameters = genericMethod.getGenericParameterTypes();
        if (genericParameters.length != (candidateParameters = candidateMethod.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < genericParameters.length; ++i) {
            Type rawType;
            Type genericParameter = genericParameters[i];
            Class<?> candidateParameter = candidateParameters[i];
            if (candidateParameter.isArray() && (rawType = GenericTypeResolver.getRawType(genericParameter, typeVariableMap)) instanceof GenericArrayType) {
                if (candidateParameter.getComponentType().equals(GenericTypeResolver.resolveType(((GenericArrayType)rawType).getGenericComponentType(), typeVariableMap))) break;
                return false;
            }
            Class<?> resolvedParameter = GenericTypeResolver.resolveType(genericParameter, typeVariableMap);
            if (candidateParameter.equals(resolvedParameter)) continue;
            return false;
        }
        return true;
    }

    private static Method searchForMatch(Class type, Method bridgeMethod) {
        return ReflectionUtils.findMethod(type, bridgeMethod.getName(), bridgeMethod.getParameterTypes());
    }

    public static boolean isVisibilityBridgeMethodPair(Method bridgeMethod, Method bridgedMethod) {
        Assert.assertTrue(bridgeMethod != null);
        Assert.assertTrue(bridgedMethod != null);
        if (bridgeMethod == bridgedMethod) {
            return true;
        }
        return Arrays.equals(bridgeMethod.getParameterTypes(), bridgedMethod.getParameterTypes()) && bridgeMethod.getReturnType().equals(bridgedMethod.getReturnType());
    }
}

