/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.commons.collection;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.tinygroup.commons.collection.Conventions;
import org.tinygroup.commons.tools.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelMap
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = -6716896917610679027L;

    public ModelMap() {
    }

    public ModelMap(String attributeName, Object attributeValue) {
        this.addAttribute(attributeName, attributeValue);
    }

    public ModelMap(Object attributeValue) {
        this.addAttribute(attributeValue);
    }

    public ModelMap addAttribute(String attributeName, Object attributeValue) {
        Assert.assertNotNull(attributeName, "Model attribute name must not be null", new Object[0]);
        this.put(attributeName, attributeValue);
        return this;
    }

    public ModelMap addAttribute(Object attributeValue) {
        Assert.assertNotNull(attributeValue, "Model object must not be null", new Object[0]);
        if (attributeValue instanceof Collection && ((Collection)attributeValue).isEmpty()) {
            return this;
        }
        return this.addAttribute(Conventions.getVariableName(attributeValue), attributeValue);
    }

    public ModelMap addAllAttributes(Collection<?> attributeValues) {
        if (attributeValues != null) {
            for (Object attributeValue : attributeValues) {
                this.addAttribute(attributeValue);
            }
        }
        return this;
    }

    public ModelMap addAllAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            this.putAll(attributes);
        }
        return this;
    }

    public ModelMap mergeAttributes(Map<String, ?> attributes) {
        if (attributes != null) {
            for (String key : attributes.keySet()) {
                if (this.containsKey(key)) continue;
                this.put(key, attributes.get(key));
            }
        }
        return this;
    }

    public boolean containsAttribute(String attributeName) {
        return this.containsKey(attributeName);
    }

    @Deprecated
    public ModelMap addObject(String modelName, Object modelObject) {
        return this.addAttribute(modelName, modelObject);
    }

    @Deprecated
    public ModelMap addObject(Object modelObject) {
        return this.addAttribute(modelObject);
    }

    @Deprecated
    public ModelMap addAllObjects(Collection<?> objects) {
        return this.addAllAttributes(objects);
    }

    @Deprecated
    public ModelMap addAllObjects(Map objects) {
        return this.addAllAttributes(objects);
    }
}

