/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.binarytree.impl;

import org.tinygroup.binarytree.AVLTree;
import org.tinygroup.binarytree.BinaryTree;
import org.tinygroup.binarytree.impl.AVLTreeImpl;
import org.tinygroup.commons.exceptions.ComparableException;
import org.tinygroup.commons.processor.Processor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryTreeImpl<T extends Comparable<T>>
implements BinaryTree<T> {
    private BinaryTreeImpl<T> parent = null;
    private BinaryTreeImpl<T> left = null;
    private BinaryTreeImpl<T> right = null;
    private T data;

    public BinaryTreeImpl(T data) {
        if (!(data instanceof Comparable)) {
            throw new ComparableException(data.getClass().getSimpleName() + " must implements from Comparable.");
        }
        this.data = data;
    }

    @Override
    public BinaryTree<T> search(T find) {
        int c = this.compare(this.left.data, find);
        if (c == 0) {
            return this;
        }
        if (c < 0) {
            return this.left.search(find);
        }
        return this.right.search(find);
    }

    @Override
    public BinaryTree<T> add(T object) {
        if (this.compare(this.data, object) > 0) {
            if (this.left == null) {
                BinaryTreeImpl<T> tree = new BinaryTreeImpl<T>(object);
                tree.parent = this;
                this.left = tree;
            } else {
                this.left.add(object);
            }
        } else if (this.compare(this.data, object) < 0) {
            if (this.right == null) {
                BinaryTreeImpl<T> tree = new BinaryTreeImpl<T>(object);
                tree.parent = this;
                this.right = tree;
            } else {
                this.right.add(object);
            }
        }
        return this;
    }

    @Override
    public T getData() {
        return this.data;
    }

    public int compare(T a, T b) {
        return a.compareTo(b);
    }

    public void swap() {
        BinaryTreeImpl<T> tree = this.left;
        this.left = this.right;
        this.right = tree;
        if (this.left != null) {
            this.left.swap();
        }
        if (this.right != null) {
            this.right.swap();
        }
    }

    @Override
    public void remove(T o) {
        if (this.compare(this.left.data, o) == 0) {
            this.left = null;
        } else if (this.compare(this.right.data, o) == 0) {
            this.right = null;
        } else {
            this.left.remove(o);
            this.right.remove(o);
        }
    }

    @Override
    public void foreach(Processor<T> process) {
        this.foreach(process, 0);
    }

    @Override
    public void foreach(Processor<T> process, int mode) {
        if (mode == 0) {
            if (this.left != null) {
                this.left.foreach(process, mode);
            }
            process.process(this.data);
            if (this.right != null) {
                this.right.foreach(process, mode);
            }
        } else if (mode == -1) {
            process.process(this.data);
            if (this.left != null) {
                this.left.foreach(process, mode);
            }
            if (this.right != null) {
                this.right.foreach(process, mode);
            }
        } else if (mode == 1) {
            if (this.left != null) {
                this.left.foreach(process, mode);
            }
            if (this.right != null) {
                this.right.foreach(process, mode);
            }
            process.process(this.data);
        }
    }

    @Override
    public int size() {
        int s = 1;
        if (this.left != null) {
            s += this.left.size();
        }
        if (this.right != null) {
            s += this.right.size();
        }
        return s;
    }

    @Override
    public int height() {
        int lh = 0;
        int rh = 0;
        if (this.left != null) {
            lh = this.left.height();
        }
        if (this.right != null) {
            rh += this.right.height();
        }
        if (lh > rh) {
            return 1 + lh;
        }
        return 1 + rh;
    }

    @Override
    public AVLTree<T> toAVLTree() {
        AVLTreeImpl avlTree = new AVLTreeImpl();
        AddToAvlTree ps = new AddToAvlTree(avlTree);
        this.foreach(ps, 0);
        return avlTree;
    }

    @Override
    public BinaryTreeImpl<T> getParent() {
        return this.parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AddToAvlTree<T extends Comparable<T>>
    implements Processor<T> {
        private AVLTree<T> tree;

        public AddToAvlTree(AVLTree<T> avlTree) {
            this.tree = avlTree;
        }

        public void process(T data) {
            this.tree.add(data);
        }
    }
}

