/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.application.impl;

import java.util.ArrayList;
import java.util.List;
import org.tinygroup.application.Application;
import org.tinygroup.application.ApplicationProcessor;
import org.tinygroup.commons.order.OrderUtil;
import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationDefault
implements Application {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationDefault.class);
    private List<ApplicationProcessor> applicationProcessors = new ArrayList<ApplicationProcessor>();

    @Override
    public void init() {
        OrderUtil.order(this.applicationProcessors);
        for (ApplicationProcessor applicationProcessor : this.applicationProcessors) {
            applicationProcessor.init();
        }
    }

    @Override
    public void start() {
        LOGGER.logMessage(LogLevel.INFO, "\u4e34\u65f6\u76ee\u5f55\uff1a" + System.getProperty("java.io.tmpdir"));
        if (this.applicationProcessors != null) {
            for (ApplicationProcessor applicationProcessor : this.applicationProcessors) {
                LOGGER.logMessage(LogLevel.INFO, "\u5e94\u7528\u5904\u7406\u5668{}\u6b63\u5728\u542f\u52a8...", new Object[]{applicationProcessor.getClass()});
                applicationProcessor.start();
                LOGGER.logMessage(LogLevel.INFO, "\u5e94\u7528\u5904\u7406\u5668{}\u542f\u52a8\u5b8c\u6bd5\u3002", new Object[]{applicationProcessor.getClass()});
            }
        }
    }

    @Override
    public void stop() {
        for (int i = this.applicationProcessors.size() - 1; i >= 0; --i) {
            ApplicationProcessor processorLoader = this.applicationProcessors.get(i);
            LOGGER.logMessage(LogLevel.INFO, "\u5e94\u7528\u5904\u7406\u5668{}\u6b63\u5728\u505c\u6b62...", new Object[]{processorLoader.getClass()});
            processorLoader.stop();
            LOGGER.logMessage(LogLevel.INFO, "\u5e94\u7528\u5904\u7406\u5668{}\u505c\u6b62\u5b8c\u6bd5\u3002", new Object[]{processorLoader.getClass()});
        }
    }

    @Override
    public void addApplicationProcessor(ApplicationProcessor applicationProcessor) {
        this.applicationProcessors.add(applicationProcessor);
        applicationProcessor.setApplication(this);
    }

    @Override
    public List<ApplicationProcessor> getApplicationProcessors() {
        return this.applicationProcessors;
    }
}

