/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.authentication.PasswordPromptDialog;
import org.tigris.subversion.subclipse.ui.authentication.QuestionDialog;
import org.tigris.subversion.subclipse.ui.authentication.SSHPromptDialog;
import org.tigris.subversion.subclipse.ui.authentication.SSLClientCertificate;
import org.tigris.subversion.subclipse.ui.authentication.TrustSSLServerDialog;
import org.tigris.subversion.subclipse.ui.authentication.UserPromptDialog;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;

public class SVNPromptUserPassword
implements ISVNPromptUserPassword {
    private String username;
    private String password;
    private boolean allowedSave;
    private String realm;
    private boolean maySave;
    private boolean rtnCode;
    private int trust;
    private String info;
    private boolean allowPermanently;
    private boolean yesNoAnswer;
    private String question;
    private boolean yesIsDefault;
    private String answer;
    private boolean showAnswer;
    private int sshPort;
    private String keyFile;
    private String passPhrase;

    public boolean askYesNo(String realm, String askQuestion, boolean askYesIsDefault) {
        this.question = askQuestion;
        this.yesIsDefault = askYesIsDefault;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog dialog;
                int defaultButton = 0;
                if (!SVNPromptUserPassword.this.yesIsDefault) {
                    defaultButton = 1;
                }
                SVNPromptUserPassword.this.yesNoAnswer = (dialog = new MessageDialog(Display.getCurrent().getActiveShell(), Policy.bind("SVNPromptUserPassword.authentication"), null, SVNPromptUserPassword.this.question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, defaultButton)).open() == 0;
            }
        });
        return this.yesNoAnswer;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int askTrustSSLServer(String trustInfo, boolean trustAllowPermanently) {
        this.info = trustInfo;
        this.allowPermanently = trustAllowPermanently;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                TrustSSLServerDialog dialog = new TrustSSLServerDialog(Display.getCurrent().getActiveShell(), SVNPromptUserPassword.this.info, SVNPromptUserPassword.this.allowPermanently);
                switch (dialog.open()) {
                    case 1: {
                        SVNPromptUserPassword.this.trust = 0;
                        break;
                    }
                    case 0: {
                        SVNPromptUserPassword.this.trust = 1;
                        break;
                    }
                    case 2: {
                        SVNPromptUserPassword.this.trust = 2;
                        break;
                    }
                    default: {
                        SVNPromptUserPassword.this.trust = 1;
                    }
                }
            }
        });
        return this.trust;
    }

    public boolean prompt(String promptRealm, String promptUsername, boolean promptMaySave) {
        this.rtnCode = false;
        this.username = promptUsername;
        this.realm = promptRealm;
        this.maySave = promptMaySave;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                PasswordPromptDialog dialog = new PasswordPromptDialog(SVNUIPlugin.getStandardDisplay().getActiveShell(), SVNPromptUserPassword.this.realm, SVNPromptUserPassword.this.username, SVNPromptUserPassword.this.maySave);
                if (dialog.open() == 0) {
                    SVNPromptUserPassword.this.username = dialog.getUsername();
                    SVNPromptUserPassword.this.password = dialog.getPassword();
                    SVNPromptUserPassword.this.allowedSave = dialog.isSave();
                    SVNPromptUserPassword.this.rtnCode = true;
                }
            }
        });
        return this.rtnCode;
    }

    public boolean promptUser(String promptRealm, String promptUsername, boolean promptMaySave) {
        this.rtnCode = false;
        this.username = promptUsername;
        this.realm = promptRealm;
        this.maySave = promptMaySave;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                UserPromptDialog dialog = new UserPromptDialog(SVNUIPlugin.getStandardDisplay().getActiveShell(), SVNPromptUserPassword.this.realm, SVNPromptUserPassword.this.username, SVNPromptUserPassword.this.maySave);
                if (dialog.open() == 0) {
                    SVNPromptUserPassword.this.username = dialog.getUsername();
                    SVNPromptUserPassword.this.allowedSave = dialog.isSave();
                    SVNPromptUserPassword.this.rtnCode = true;
                }
            }
        });
        return this.rtnCode;
    }

    public String askQuestion(String askRealm, String askQuestion, boolean askShowAnswer, boolean askMaySave) {
        this.answer = null;
        this.realm = askRealm;
        this.maySave = askMaySave;
        this.showAnswer = askShowAnswer;
        this.question = askQuestion;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                QuestionDialog dialog = new QuestionDialog(Display.getCurrent().getActiveShell(), SVNPromptUserPassword.this.realm, SVNPromptUserPassword.this.question, true, SVNPromptUserPassword.this.maySave);
                if (dialog.open() == 0) {
                    SVNPromptUserPassword.this.allowedSave = dialog.isSave();
                    SVNPromptUserPassword.this.answer = dialog.getAnswer();
                }
            }
        });
        return this.answer;
    }

    public boolean userAllowedSave() {
        return this.allowedSave;
    }

    public int getSSHPort() {
        return this.sshPort;
    }

    public String getSSHPrivateKeyPassphrase() {
        return this.passPhrase;
    }

    public String getSSHPrivateKeyPath() {
        return this.keyFile;
    }

    public boolean promptSSH(String promptRealm, String promptUsername, int promptPort, boolean promptMaySave) {
        this.rtnCode = false;
        this.username = promptUsername;
        this.realm = promptRealm;
        this.maySave = promptMaySave;
        this.sshPort = promptPort;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                SSHPromptDialog dialog = new SSHPromptDialog(SVNUIPlugin.getStandardDisplay().getActiveShell(), SVNPromptUserPassword.this.realm, SVNPromptUserPassword.this.username, SVNPromptUserPassword.this.sshPort, SVNPromptUserPassword.this.maySave);
                if (dialog.open() == 0) {
                    SVNPromptUserPassword.this.username = dialog.getUsername();
                    SVNPromptUserPassword.this.password = dialog.getPassword();
                    SVNPromptUserPassword.this.sshPort = dialog.getSshPort();
                    SVNPromptUserPassword.this.keyFile = dialog.getKeyFile();
                    SVNPromptUserPassword.this.passPhrase = dialog.getPassphrase();
                    SVNPromptUserPassword.this.allowedSave = dialog.isSave();
                    SVNPromptUserPassword.this.rtnCode = true;
                }
            }
        });
        return this.rtnCode;
    }

    public String getSSLClientCertPassword() {
        return this.passPhrase;
    }

    public String getSSLClientCertPath() {
        return this.keyFile;
    }

    public boolean promptSSL(String promptRealm, boolean promptMaySave) {
        this.rtnCode = false;
        this.realm = promptRealm;
        this.maySave = promptMaySave;
        SVNUIPlugin.getStandardDisplay().syncExec(new Runnable(){

            public void run() {
                SSLClientCertificate dialog = new SSLClientCertificate(SVNUIPlugin.getStandardDisplay().getActiveShell(), SVNPromptUserPassword.this.realm, SVNPromptUserPassword.this.maySave);
                if (dialog.open() == 0) {
                    SVNPromptUserPassword.this.keyFile = dialog.getKeyFile();
                    SVNPromptUserPassword.this.passPhrase = dialog.getPassphrase();
                    SVNPromptUserPassword.this.allowedSave = dialog.isSave();
                    SVNPromptUserPassword.this.rtnCode = true;
                }
            }
        });
        return this.rtnCode;
    }
}

