/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.authentication;

import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.tigris.subversion.subclipse.ui.Policy;

public class QuestionDialog
extends TrayDialog {
    private String realm;
    private String question;
    private boolean showAnswer;
    private boolean maySave;
    private Text answerText;
    private String answer;
    private boolean save;
    private Button saveButton;
    private static final int WIDTH = 300;

    public QuestionDialog(Shell parentShell, String realm, String question, boolean showAnswer, boolean maySave) {
        super(parentShell);
        this.realm = realm;
        this.question = question;
        this.showAnswer = showAnswer;
        this.maySave = maySave;
    }

    protected Control createDialogArea(Composite parent) {
        Composite rtnGroup = (Composite)super.createDialogArea(parent);
        this.getShell().setText(Policy.bind("SVNPromptUserPassword.authentication"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rtnGroup.setLayout((Layout)layout);
        rtnGroup.setLayoutData((Object)new GridData(32));
        Label realmLabel = new Label(rtnGroup, 0);
        realmLabel.setText(Policy.bind("PasswordPromptDialog.repository"));
        Text realmText = new Text(rtnGroup, 2048);
        GridData gd = new GridData();
        gd.widthHint = 300;
        realmText.setLayoutData((Object)gd);
        realmText.setEditable(false);
        realmText.setText(this.realm);
        Label questionLabel = new Label(rtnGroup, 0);
        questionLabel.setText(this.question);
        this.answerText = new Text(rtnGroup, 0);
        gd = new GridData();
        gd.widthHint = 300;
        this.answerText.setLayoutData((Object)gd);
        if (!this.showAnswer) {
            this.answerText.setEchoChar('*');
        }
        if (this.maySave) {
            this.saveButton = new Button(rtnGroup, 32);
            this.saveButton.setText(Policy.bind("QuestionDialog.save"));
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.saveButton.setLayoutData((Object)gd);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)rtnGroup, "org.tigris.subversion.subclipse.ui.question_dialog_context");
        this.answerText.setFocus();
        return rtnGroup;
    }

    protected void okPressed() {
        this.answer = this.answerText.getText().trim();
        if (this.maySave) {
            this.save = this.saveButton.getSelection();
        }
        super.okPressed();
    }

    public String getAnswer() {
        return this.answer;
    }

    public boolean isSave() {
        return this.save;
    }
}

