/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.testable;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.testing.templateengine.engine.TestExecutor;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.testing.templateengine.testable.AbstractTest;
import org.thymeleaf.testing.templateengine.testable.ITestResult;
import org.thymeleaf.testing.templateengine.testable.TestResult;
import org.thymeleaf.testing.templateengine.util.ResultCompareUtils;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Test
extends AbstractTest {
    public static boolean DEFAULT_EXACT_MATCH = false;
    private ITestResource output;
    private Class<? extends Throwable> outputThrowableClass;
    private String outputThrowableMessagePattern;
    private boolean exactMatch = DEFAULT_EXACT_MATCH;

    public ITestResource getOutput() {
        return this.output;
    }

    public void setOutput(ITestResource output) {
        this.output = output;
    }

    public Class<? extends Throwable> getOutputThrowableClass() {
        return this.outputThrowableClass;
    }

    public void setOutputThrowableClass(Class<? extends Throwable> outputThrowableClass) {
        this.outputThrowableClass = outputThrowableClass;
    }

    public String getOutputThrowableMessagePattern() {
        return this.outputThrowableMessagePattern;
    }

    public void setOutputThrowableMessagePattern(String outputThrowableMessagePattern) {
        this.outputThrowableMessagePattern = outputThrowableMessagePattern;
    }

    public boolean isExactMatch() {
        return this.exactMatch;
    }

    public void setExactMatch(boolean exactMatch) {
        this.exactMatch = exactMatch;
    }

    public boolean isSuccessExpected() {
        return this.getOutputThrowableClass() == null;
    }

    private void validateTestOutput() {
        if (this.getOutput() != null) {
            if (this.getOutputThrowableClass() != null || this.getOutputThrowableMessagePattern() != null) {
                throw new TestEngineExecutionException("Test \"" + TestExecutor.getThreadTestName() + "\" specifies both an output " + "(as if success was expected) and an exception or exception pattern (as if fail " + "was expected). Only one is allowed.");
            }
        } else if (this.getOutputThrowableClass() == null) {
            throw new TestEngineExecutionException("Test \"" + TestExecutor.getThreadTestName() + "\" specifies neither an output " + "(as if success was expected) nor an exception or exception pattern (as if fail " + "was expected).");
        }
    }

    @Override
    public final ITestResult evalResult(String executionId, String testName, String result) {
        this.validateTestOutput();
        if (!this.isSuccessExpected()) {
            return this.evalResultFailExpected(executionId, testName, result);
        }
        return this.evalResultSuccessExpected(executionId, testName, result);
    }

    @Override
    public final ITestResult evalResult(String executionId, String testName, Throwable t) {
        this.validateTestOutput();
        if (!this.isSuccessExpected()) {
            return this.evalResultFailExpected(executionId, testName, t);
        }
        return this.evalResultSuccessExpected(executionId, testName, t);
    }

    protected ITestResult evalResultSuccessExpected(String executionId, String testName, String result) {
        ITestResource outputEval;
        if (result == null) {
            TestResult.error(testName, "Result is null");
        }
        if ((outputEval = this.getOutput()) == null) {
            throw new TestEngineExecutionException("Test \"" + testName + "\" does not specify an output, but success-expected " + "tests should always specify one");
        }
        if (!(outputEval instanceof ITestResourceItem)) {
            throw new TestEngineExecutionException("Test \"" + testName + "\" specifies an output which is a container, not an item " + "(maybe a folder?)");
        }
        String outputStr = ((ITestResourceItem)outputEval).readAsText();
        if (outputStr == null) {
            throw new TestEngineExecutionException("Cannot execute: Test with name \"" + testName + "\" resolved its output resource as null");
        }
        ResultCompareUtils.ResultComparison comparison = ResultCompareUtils.compareResults(outputStr, result, !this.exactMatch);
        if (comparison.getResult()) {
            return TestResult.ok(testName);
        }
        return TestResult.error(testName, comparison.getExplanation());
    }

    protected ITestResult evalResultFailExpected(String executionId, String testName, String result) {
        return TestResult.error(testName, "An exception of class " + this.getOutputThrowableClass().getName() + " was expected");
    }

    protected ITestResult evalResultSuccessExpected(String executionId, String testName, Throwable t) {
        Validate.notNull((Object)t, (String)"Throwable cannot be null");
        return TestResult.error(testName, t);
    }

    protected ITestResult evalResultFailExpected(String executionId, String testName, Throwable t) {
        Validate.notNull((Object)t, (String)"Throwable cannot be null");
        Class<? extends Throwable> outputThrowableClassEval = this.getOutputThrowableClass();
        if (outputThrowableClassEval == null) {
            throw new TestEngineExecutionException("Test \"" + testName + "\" does not specify an output throwable, but fail-expected " + "tests should always specify one");
        }
        if (Test.throwableClassMatches(outputThrowableClassEval, t)) {
            String outputThrowableMessagePatternEval = this.getOutputThrowableMessagePattern();
            if (outputThrowableMessagePatternEval != null) {
                Pattern outputThrowableMessagePatternObjectEval = Pattern.compile(outputThrowableMessagePatternEval);
                if (Test.throwableMessageMatches(outputThrowableMessagePatternObjectEval, t)) {
                    return TestResult.ok(testName, t);
                }
                return TestResult.error(testName, "An exception of class " + t.getClass() + " was raised as expected, " + "but its message does not match pattern \"" + outputThrowableMessagePatternEval + "\"", t);
            }
            return TestResult.ok(testName, t);
        }
        return TestResult.error(testName, "An exception of class " + t.getClass() + " was raised, but " + this.outputThrowableClass.getName() + " was expected instead", t);
    }

    private static boolean throwableClassMatches(Class<? extends Throwable> outputThrowableClass, Throwable throwable) {
        if (outputThrowableClass.isAssignableFrom(throwable.getClass())) {
            return true;
        }
        if (throwable.getCause() != null) {
            return Test.throwableClassMatches(outputThrowableClass, throwable.getCause());
        }
        return false;
    }

    private static boolean throwableMessageMatches(Pattern throwableMessagePattern, Throwable throwable) {
        Matcher matcher;
        String throwableMessage = throwable.getMessage();
        if (throwableMessage != null && (matcher = throwableMessagePattern.matcher(throwableMessage)).matches()) {
            return true;
        }
        if (throwable.getCause() != null) {
            return Test.throwableMessageMatches(throwableMessagePattern, throwable.getCause());
        }
        return false;
    }
}

