/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.engine;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.testing.templateengine.context.IProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.context.web.WebProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.engine.TestExecutionContext;
import org.thymeleaf.testing.templateengine.engine.TestExecutionResult;
import org.thymeleaf.testing.templateengine.engine.cache.TestCacheManager;
import org.thymeleaf.testing.templateengine.engine.resolver.TestEngineMessageResolver;
import org.thymeleaf.testing.templateengine.engine.resolver.TestEngineTemplateResolver;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.report.ConsoleTestReporter;
import org.thymeleaf.testing.templateengine.report.ITestReporter;
import org.thymeleaf.testing.templateengine.resolver.ITestableResolver;
import org.thymeleaf.testing.templateengine.standard.resolver.StandardTestableResolver;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.testable.ITestIterator;
import org.thymeleaf.testing.templateengine.testable.ITestParallelizer;
import org.thymeleaf.testing.templateengine.testable.ITestResult;
import org.thymeleaf.testing.templateengine.testable.ITestSequence;
import org.thymeleaf.testing.templateengine.testable.ITestable;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestExecutor {
    private ITestableResolver testableResolver = new StandardTestableResolver();
    private IProcessingContextBuilder processingContextBuilder = new WebProcessingContextBuilder();
    private List<IDialect> dialects = Collections.singletonList(new StandardDialect());
    protected ITestReporter reporter = new ConsoleTestReporter();
    private static ThreadLocal<String> threadExecutionId = new ThreadLocal();
    private static ThreadLocal<String> threadTestName = new ThreadLocal();
    private static ThreadLocal<ITest> threadTest = new ThreadLocal();

    public static String getThreadExecutionId() {
        return threadExecutionId.get();
    }

    public static String getThreadTestName() {
        return threadTestName.get();
    }

    public static ITest getThreadTest() {
        return threadTest.get();
    }

    protected static void setThreadExecutionId(String executionId) {
        threadExecutionId.set(executionId);
    }

    private static void setThreadTestName(String testName) {
        threadTestName.set(testName);
    }

    private static void setThreadTest(ITest test) {
        threadTest.set(test);
    }

    public ITestableResolver getTestableResolver() {
        return this.testableResolver;
    }

    public void setTestableResolver(ITestableResolver testableResolver) {
        this.testableResolver = testableResolver;
    }

    public IProcessingContextBuilder getProcessingContextBuilder() {
        return this.processingContextBuilder;
    }

    public void setProcessingContextBuilder(IProcessingContextBuilder processingContextBuilder) {
        Validate.notNull((Object)processingContextBuilder, (String)"Processing Context Builder cannot be null");
        this.processingContextBuilder = processingContextBuilder;
    }

    public void setDialects(List<? extends IDialect> dialects) {
        this.dialects = new ArrayList<IDialect>();
        this.dialects.addAll(dialects);
        this.dialects = Collections.unmodifiableList(dialects);
    }

    public List<IDialect> getDialects() {
        return this.dialects;
    }

    public void setReporter(ITestReporter reporter) {
        Validate.notNull((Object)reporter, (String)"Reporter cannot be null");
        this.reporter = reporter;
    }

    public ITestReporter getReporter() {
        return this.reporter;
    }

    public void execute(String testableName) {
        TestExecutionContext context = new TestExecutionContext();
        String executionId = context.getExecutionId();
        TestExecutor.setThreadExecutionId(executionId);
        try {
            ITestable testable = this.testableResolver.resolve(executionId, testableName);
            if (testable == null) {
                throw new TestEngineExecutionException("Resource \"" + testableName + "\" could not be resolved.");
            }
            this.execute(testable, context);
        }
        catch (TestEngineExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Error executing testable \"" + testableName + "\"", e);
        }
    }

    private void execute(ITestable testable, TestExecutionContext context) {
        Validate.notNull((Object)testable, (String)"Testable cannot be null");
        Validate.notNull((Object)context, (String)"Test execution context cannot be null");
        TestEngineTemplateResolver templateResolver = new TestEngineTemplateResolver();
        TestEngineMessageResolver messageResolver = new TestEngineMessageResolver();
        TestCacheManager cacheManager = new TestCacheManager();
        TemplateEngine templateEngine = new TemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)templateResolver);
        templateEngine.setMessageResolver((IMessageResolver)messageResolver);
        templateEngine.setDialects(new HashSet<IDialect>(this.dialects));
        templateEngine.setCacheManager((ICacheManager)cacheManager);
        context.setTemplateEngine(templateEngine);
        this.reporter.executionStart(context.getExecutionId());
        TestExecutionResult result = this.executeTestable(testable, context);
        this.reporter.executionEnd(context.getExecutionId(), result.getTotalTestsOk(), result.getTotalTestsExecuted(), result.getTotalTimeNanos());
    }

    protected TestExecutionResult executeTestable(ITestable testable, TestExecutionContext context) {
        Validate.notNull((Object)testable, (String)"Testable cannot be null");
        if (testable instanceof ITestSequence) {
            return this.executeSequence((ITestSequence)testable, context);
        }
        if (testable instanceof ITestIterator) {
            return this.executeIterator((ITestIterator)testable, context);
        }
        if (testable instanceof ITestParallelizer) {
            return this.executeParallelizer((ITestParallelizer)testable, context);
        }
        if (testable instanceof ITest) {
            return this.executeTest((ITest)testable, context);
        }
        throw new TestEngineExecutionException("ITestable implementation \"" + testable.getClass() + "\" is not recognized");
    }

    private TestExecutionResult executeSequence(ITestSequence sequence, TestExecutionContext context) {
        Validate.notNull((Object)sequence, (String)"Sequence cannot be null");
        Validate.notNull((Object)context, (String)"Test execution context cannot be null");
        this.reporter.sequenceStart(context.getExecutionId(), context.getNestingLevel(), sequence);
        TestExecutionResult result = new TestExecutionResult();
        List<ITestable> elements = sequence.getElements();
        for (ITestable element : elements) {
            result.addResult(this.executeTestable(element, context.nest()));
        }
        this.reporter.sequenceEnd(context.getExecutionId(), context.getNestingLevel(), sequence, result.getTotalTestsOk(), result.getTotalTestsExecuted(), result.getTotalTimeNanos());
        return result;
    }

    private TestExecutionResult executeIterator(ITestIterator iterator, TestExecutionContext context) {
        Validate.notNull((Object)iterator, (String)"Iterator cannot be null");
        Validate.notNull((Object)context, (String)"Test execution context cannot be null");
        this.reporter.iteratorStart(context.getExecutionId(), context.getNestingLevel(), iterator);
        int iterations = iterator.getIterations();
        ITestable element = iterator.getIteratedElement();
        TestExecutionResult result = new TestExecutionResult();
        TestExecutionContext iterationContext = context.nest();
        for (int i = 1; i <= iterations; ++i) {
            this.reporter.iterationStart(context.getExecutionId(), iterationContext.getNestingLevel(), iterator, i);
            TestExecutionResult elementResult = this.executeTestable(element, iterationContext.nest());
            this.reporter.iterationEnd(context.getExecutionId(), iterationContext.getNestingLevel(), iterator, i, elementResult.getTotalTestsOk(), elementResult.getTotalTestsExecuted(), elementResult.getTotalTimeNanos());
            result.addResult(elementResult);
        }
        this.reporter.iteratorEnd(context.getExecutionId(), context.getNestingLevel(), iterator, result.getTotalTestsOk(), result.getTotalTestsExecuted(), result.getTotalTimeNanos());
        return result;
    }

    private TestExecutionResult executeParallelizer(ITestParallelizer parallelizer, TestExecutionContext context) {
        Validate.notNull((Object)parallelizer, (String)"Parallelizer cannot be null");
        Validate.notNull((Object)context, (String)"Test execution context cannot be null");
        int numThreads = parallelizer.getNumThreads();
        ArrayList<FutureTask<TestExecutionResult>> tasks = new ArrayList<FutureTask<TestExecutionResult>>();
        TestExecutionResult result = new TestExecutionResult();
        ThreadPoolExecutor threadExecutor = new ThreadPoolExecutor(numThreads, numThreads, Long.MAX_VALUE, TimeUnit.NANOSECONDS, new SynchronousQueue<Runnable>());
        this.reporter.parallelizerStart(context.getExecutionId(), context.getNestingLevel(), parallelizer);
        for (int i = 1; i <= numThreads; ++i) {
            ExecutorTask executorTask = new ExecutorTask(this, parallelizer, context, i);
            FutureTask<TestExecutionResult> futureTask = new FutureTask<TestExecutionResult>(executorTask);
            tasks.add(futureTask);
            threadExecutor.execute(futureTask);
        }
        for (FutureTask futureTask : tasks) {
            try {
                result.addResult((TestExecutionResult)futureTask.get());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        threadExecutor.shutdown();
        this.reporter.parallelizerEnd(context.getExecutionId(), context.getNestingLevel(), parallelizer, result.getTotalTestsOk(), result.getTotalTestsExecuted(), result.getTotalTimeNanos());
        return result;
    }

    private TestExecutionResult executeTest(ITest test, TestExecutionContext context) {
        long endTimeNanos;
        Validate.notNull((Object)test, (String)"Test cannot be null");
        Validate.notNull((Object)context, (String)"Test execution context cannot be null");
        String executionId = context.getExecutionId();
        String testName = context.getTestNamer().nameTest(test);
        TemplateEngine templateEngine = context.getTemplateEngine();
        TestExecutor.setThreadTest(test);
        TestExecutor.setThreadTestName(testName);
        this.reporter.testStart(executionId, context.getNestingLevel(), test, testName);
        IFragmentSpec fragmentSpec = test.getFragmentSpec();
        IProcessingContext processingContext = this.processingContextBuilder.build(test);
        StringWriter writer = new StringWriter();
        ITestResult testResult = null;
        long startTimeNanos = System.nanoTime();
        try {
            templateEngine.process(testName, processingContext, fragmentSpec, (Writer)writer);
            endTimeNanos = System.nanoTime();
            String result = writer.toString();
            testResult = test.evalResult(executionId, testName, result);
        }
        catch (Throwable t) {
            endTimeNanos = System.nanoTime();
            testResult = test.evalResult(executionId, testName, t);
        }
        long totalTimeNanos = endTimeNanos - startTimeNanos;
        this.reporter.testEnd(executionId, context.getNestingLevel(), test, testName, testResult, totalTimeNanos);
        TestExecutionResult result = new TestExecutionResult();
        result.addTestResult(testResult.isOK(), totalTimeNanos);
        TestExecutor.setThreadTestName(null);
        TestExecutor.setThreadTest(null);
        return result;
    }

    public final void reset() {
        if (this.reporter != null) {
            this.reporter.reset();
        }
    }

    public final boolean isAllOK() {
        if (this.reporter != null) {
            return this.reporter.isAllOK();
        }
        throw new TestEngineExecutionException("Cannot execute 'isAllOK()' call: no test reporter has been set");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ExecutorTask
    implements Callable<TestExecutionResult> {
        private final TestExecutor executor;
        private final TestExecutionContext context;
        private final ITestParallelizer parallelizer;
        private final int threadNumber;

        ExecutorTask(TestExecutor executor, ITestParallelizer parallelizer, TestExecutionContext context, int threadNumber) {
            this.executor = executor;
            this.context = context;
            this.parallelizer = parallelizer;
            this.threadNumber = threadNumber;
        }

        @Override
        public TestExecutionResult call() {
            TestExecutionContext threadExecutionContext = this.context.nest();
            TestExecutor.setThreadExecutionId(threadExecutionContext.getExecutionId());
            ITestable parallelizedElement = this.parallelizer.getParallelizedElement();
            this.executor.reporter.parallelThreadStart(this.context.getExecutionId(), threadExecutionContext.getNestingLevel(), this.parallelizer, this.threadNumber);
            TestExecutionResult result = this.executor.executeTestable(parallelizedElement, threadExecutionContext.nest());
            this.executor.reporter.parallelThreadEnd(this.context.getExecutionId(), threadExecutionContext.getNestingLevel(), this.parallelizer, this.threadNumber, result.getTotalTestsOk(), result.getTotalTestsExecuted(), result.getTotalTimeNanos());
            return result;
        }
    }
}

