/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTestEvaluatedData {
    private final String documentName;
    private final Map<String, Map<String, StandardTestEvaluatedField>> valuesByFieldAndQualifier;

    public StandardTestEvaluatedData(String documentName) {
        Validate.notNull((Object)documentName, (String)"Document name cannot be null");
        this.documentName = documentName;
        this.valuesByFieldAndQualifier = new HashMap<String, Map<String, StandardTestEvaluatedField>>();
    }

    public String getDocumentName() {
        return this.documentName;
    }

    public Set<String> getFieldNames() {
        return this.valuesByFieldAndQualifier.keySet();
    }

    public Set<String> getQualifiersForField(String fieldName) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, StandardTestEvaluatedField> valuesByQualifierForField = this.getValuesByQualifierForField(fieldName);
        if (valuesByQualifierForField == null) {
            return Collections.emptySet();
        }
        return valuesByQualifierForField.keySet();
    }

    public StandardTestEvaluatedField getValueForFieldAndQualifier(String fieldName, String fieldQualifier) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, StandardTestEvaluatedField> valuesByQualifierForField = this.getValuesByQualifierForField(fieldName);
        if (valuesByQualifierForField == null) {
            return null;
        }
        return valuesByQualifierForField.get(fieldQualifier);
    }

    public Map<String, StandardTestEvaluatedField> getValuesByQualifierForField(String fieldName) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, StandardTestEvaluatedField> valuesByQualifierForField = this.valuesByFieldAndQualifier.get(fieldName);
        if (valuesByQualifierForField == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(valuesByQualifierForField);
    }

    public void setValue(String fieldName, String fieldQualifier, StandardTestEvaluatedField value) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, StandardTestEvaluatedField> valuesByQualifierForField = this.valuesByFieldAndQualifier.get(fieldName);
        if (valuesByQualifierForField == null) {
            valuesByQualifierForField = new HashMap<String, StandardTestEvaluatedField>();
            this.valuesByFieldAndQualifier.put(fieldName, valuesByQualifierForField);
        }
        valuesByQualifierForField.put(fieldQualifier, value);
    }
}

