/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.builder;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.messages.ITestMessagesForLocale;
import org.thymeleaf.testing.templateengine.messages.TestMessages;
import org.thymeleaf.testing.templateengine.resolver.ITestableResolver;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.standard.test.StandardTest;
import org.thymeleaf.testing.templateengine.standard.test.StandardTestValueType;
import org.thymeleaf.testing.templateengine.standard.test.builder.IStandardTestBuilder;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedData;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestFieldNaming;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.testable.ITestable;
import org.thymeleaf.testing.templateengine.testable.Test;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public class StandardTestBuilder
implements IStandardTestBuilder {
    private ITestableResolver testableResolver = null;

    public StandardTestBuilder() {
    }

    public StandardTestBuilder(ITestableResolver testableResolver) {
        this.setTestableResolver(testableResolver);
    }

    public ITestableResolver getTestableResolver() {
        return this.testableResolver;
    }

    public void setTestableResolver(ITestableResolver testableResolver) {
        this.testableResolver = testableResolver;
    }

    public final ITest buildTest(String executionId, StandardTestEvaluatedData data) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)data, (String)"Data cannot be null");
        StandardTestEvaluatedField name = StandardTestBuilder.getFieldValueForMainQualifier(data, "NAME");
        StandardTestEvaluatedField cache = StandardTestBuilder.getFieldValueForMainQualifier(data, "CACHE");
        StandardTestEvaluatedField context = StandardTestBuilder.getFieldValueForMainQualifier(data, "CONTEXT");
        Map<String, StandardTestEvaluatedField> messages = data.getValuesByQualifierForField("MESSAGES");
        StandardTestEvaluatedField templateMode = StandardTestBuilder.getFieldValueForMainQualifier(data, "TEMPLATE_MODE");
        StandardTestEvaluatedField fragmentSpec = StandardTestBuilder.getFieldValueForMainQualifier(data, "FRAGMENT");
        Map<String, StandardTestEvaluatedField> inputs = data.getValuesByQualifierForField("INPUT");
        StandardTestEvaluatedField output = StandardTestBuilder.getFieldValueForMainQualifier(data, "OUTPUT");
        StandardTestEvaluatedField exception = StandardTestBuilder.getFieldValueForMainQualifier(data, "EXCEPTION");
        StandardTestEvaluatedField exceptionMessagePattern = StandardTestBuilder.getFieldValueForMainQualifier(data, "EXCEPTION_MESSAGE_PATTERN");
        StandardTestEvaluatedField exactMatch = StandardTestBuilder.getFieldValueForMainQualifier(data, "EXACT_MATCH");
        StandardTestEvaluatedField extendsTest = StandardTestBuilder.getFieldValueForMainQualifier(data, "EXTENDS");
        StandardTestEvaluatedField mainInput = inputs != null ? inputs.get(StandardTestFieldNaming.FIELD_QUALIFIER_MAIN) : null;
        HashMap<String, StandardTestEvaluatedField> additionalInputs = inputs != null ? new HashMap<String, StandardTestEvaluatedField>(inputs) : new HashMap();
        additionalInputs.remove(StandardTestFieldNaming.FIELD_QUALIFIER_MAIN);
        ITest parentTest = null;
        if (extendsTest != null && extendsTest.hasNotNullValue()) {
            if (this.testableResolver == null) {
                throw new TestEngineExecutionException("Cannot resolve \"EXTENDS\" field: no " + ITestableResolver.class.getSimpleName() + " has been specified at the test builder.");
            }
            String extendsValue = (String)extendsTest.getValue();
            ITestable parentTestable = this.testableResolver.resolve(executionId, extendsValue);
            if (parentTestable == null) {
                throw new TestEngineExecutionException("Cannot resolve \"EXTENDS\" field: \"" + extendsValue + "\" resolved as null.");
            }
            if (!(parentTestable instanceof ITest)) {
                throw new TestEngineExecutionException("Cannot resolve \"EXTENDS\" field: \"" + extendsValue + "\" resolved as a " + parentTestable.getClass().getName() + " object instead of an " + ITest.class.getName() + " implementation.");
            }
            parentTest = (ITest)parentTestable;
        }
        StandardTest test = this.createTestInstance();
        if (name != null && name.hasValue()) {
            test.setName((String)name.getValue(), name.getValueType());
        }
        if (templateMode != null && templateMode.hasValue()) {
            test.setTemplateMode((String)templateMode.getValue(), templateMode.getValueType());
        }
        if (context != null && context.hasValue()) {
            test.setContext((ITestContext)context.getValue(), context.getValueType());
        }
        if (messages != null) {
            TestMessages testMessages = new TestMessages();
            for (Map.Entry<String, StandardTestEvaluatedField> entry : messages.entrySet()) {
                Locale locale;
                Locale locale2 = locale = StringUtils.isEmpty((Object)entry.getKey()) != false ? null : new Locale(entry.getKey());
                StandardTestEvaluatedField field = entry.getValue();
                if (field == null || !field.hasNotNullValue()) continue;
                testMessages.setMessagesForLocale(locale, (ITestMessagesForLocale)field.getValue());
            }
            test.setMessages(testMessages, StandardTestValueType.SPECIFIED);
        }
        if (cache != null && cache.hasNotNullValue()) {
            test.setInputCacheable((Boolean)cache.getValue(), cache.getValueType());
        }
        if (fragmentSpec != null && fragmentSpec.hasValue()) {
            test.setFragmentSpec((IFragmentSpec)fragmentSpec.getValue(), fragmentSpec.getValueType());
        }
        if (mainInput != null && mainInput.hasValue()) {
            test.setInput((ITestResource)mainInput.getValue(), mainInput.getValueType());
        }
        for (Map.Entry additionalInputEntry : additionalInputs.entrySet()) {
            StandardTestEvaluatedField additionalInputField = (StandardTestEvaluatedField)additionalInputEntry.getValue();
            if (additionalInputField == null) continue;
            test.setAdditionalInput((String)additionalInputEntry.getKey(), (ITestResource)additionalInputField.getValue(), additionalInputField.getValueType());
        }
        if (output != null && output.hasValue()) {
            test.setOutput((ITestResource)output.getValue(), output.getValueType());
        }
        if (exception != null && exception.hasValue()) {
            test.setOutputThrowableClass((Class)exception.getValue(), exception.getValueType());
        }
        if (exceptionMessagePattern != null && exceptionMessagePattern.hasValue()) {
            test.setOutputThrowableMessagePattern((String)exceptionMessagePattern.getValue(), exceptionMessagePattern.getValueType());
        }
        if (exactMatch != null && exactMatch.hasNotNullValue()) {
            test.setExactMatch((Boolean)exactMatch.getValue(), exactMatch.getValueType());
        }
        if (parentTest != null) {
            StandardTest standardParentTest = parentTest instanceof StandardTest ? (StandardTest)parentTest : null;
            ITestContext parentContext = standardParentTest != null ? standardParentTest.getContext() : null;
            ITestContext newContext = parentContext != null ? parentContext.aggregate(test.getContext()) : test.getContext();
            test.setContext(newContext, StandardTestValueType.SPECIFIED);
            ITestMessages parentMessages = standardParentTest != null ? standardParentTest.getMessages() : null;
            ITestMessages newMessages = parentMessages != null ? parentMessages.aggregate(test.getMessages()) : test.getMessages();
            test.setMessages(newMessages, StandardTestValueType.SPECIFIED);
            if (StandardTestBuilder.shouldSetValueFromParent(test.getNameValueType(), standardParentTest != null ? standardParentTest.getNameValueType() : null)) {
                test.setName(parentTest.getName(), StandardTestValueType.SPECIFIED);
            }
            if (StandardTestBuilder.shouldSetValueFromParent(test.getTemplateModeValueType(), standardParentTest != null ? standardParentTest.getTemplateModeValueType() : null)) {
                test.setTemplateMode(parentTest.getTemplateMode(), StandardTestValueType.SPECIFIED);
            }
            if (StandardTestBuilder.shouldSetValueFromParent(test.getCacheValueType(), standardParentTest != null ? standardParentTest.getCacheValueType() : null)) {
                test.setInputCacheable(parentTest.isInputCacheable(), StandardTestValueType.SPECIFIED);
            }
            if (StandardTestBuilder.shouldSetValueFromParent(test.getFragmentValueType(), standardParentTest != null ? standardParentTest.getFragmentValueType() : null)) {
                test.setFragmentSpec(parentTest.getFragmentSpec(), StandardTestValueType.SPECIFIED);
            }
            if (StandardTestBuilder.shouldSetValueFromParent(test.getInputValueType(), standardParentTest != null ? standardParentTest.getInputValueType() : null)) {
                test.setInput(parentTest.getInput(), StandardTestValueType.SPECIFIED);
            }
            for (Map.Entry<String, ITestResource> additionalInputEntry : parentTest.getAdditionalInputs().entrySet()) {
                StandardTestValueType parentAdditionalInputValueType;
                String inputName = additionalInputEntry.getKey();
                ITestResource inputTestResource = additionalInputEntry.getValue();
                StandardTestValueType additionalInputValueType = test.getAdditionalInputsValueTypes(inputName);
                StandardTestValueType standardTestValueType = parentAdditionalInputValueType = standardParentTest != null ? standardParentTest.getAdditionalInputsValueTypes(inputName) : null;
                if (additionalInputValueType != null && !StandardTestBuilder.shouldSetValueFromParent(additionalInputValueType, parentAdditionalInputValueType)) continue;
                test.setAdditionalInput(inputName, inputTestResource, StandardTestValueType.SPECIFIED);
            }
            if (parentTest instanceof Test) {
                if (StandardTestBuilder.shouldSetValueFromParent(test.getOutputValueType(), standardParentTest != null ? standardParentTest.getOutputValueType() : null)) {
                    test.setOutput(((Test)parentTest).getOutput(), StandardTestValueType.SPECIFIED);
                }
                if (StandardTestBuilder.shouldSetValueFromParent(test.getOutputThrowableClassValueType(), standardParentTest != null ? standardParentTest.getOutputThrowableClassValueType() : null)) {
                    test.setOutputThrowableClass(((Test)parentTest).getOutputThrowableClass(), StandardTestValueType.SPECIFIED);
                }
                if (StandardTestBuilder.shouldSetValueFromParent(test.getOutputThrowableMessagePatternValueType(), standardParentTest != null ? standardParentTest.getOutputThrowableMessagePatternValueType() : null)) {
                    test.setOutputThrowableMessagePattern(((Test)parentTest).getOutputThrowableMessagePattern(), StandardTestValueType.SPECIFIED);
                }
                if (StandardTestBuilder.shouldSetValueFromParent(test.getExactMatchValueType(), standardParentTest != null ? standardParentTest.getExactMatchValueType() : null)) {
                    test.setExactMatch(((Test)parentTest).isExactMatch(), StandardTestValueType.SPECIFIED);
                }
            }
        }
        this.additionalInitialization(test, parentTest, data);
        return test;
    }

    private static StandardTestEvaluatedField getFieldValueForMainQualifier(StandardTestEvaluatedData data, String fieldName) {
        Map<String, StandardTestEvaluatedField> valuesByQualifierForField = data.getValuesByQualifierForField(fieldName);
        if (valuesByQualifierForField == null) {
            return null;
        }
        return valuesByQualifierForField.get(StandardTestFieldNaming.FIELD_QUALIFIER_MAIN);
    }

    private static boolean shouldSetValueFromParent(StandardTestValueType valueType, StandardTestValueType parentValueType) {
        if (valueType.equals((Object)StandardTestValueType.NO_VALUE)) {
            return true;
        }
        if (valueType.equals((Object)StandardTestValueType.DEFAULT)) {
            if (parentValueType != null) {
                return parentValueType.equals((Object)StandardTestValueType.SPECIFIED);
            }
            return true;
        }
        return false;
    }

    protected StandardTest createTestInstance() {
        return new StandardTest();
    }

    protected void additionalInitialization(StandardTest test, ITest parentTest, StandardTestEvaluatedData data) {
    }
}

