/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.standard.test.StandardTestValueType;
import org.thymeleaf.testing.templateengine.testable.Test;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardTest
extends Test {
    public static final StandardTestValueType DEFAULT_VALUE_TYPE = StandardTestValueType.SPECIFIED;
    private Map<String, StandardTestValueType> additionalInputsValueTypes = new HashMap<String, StandardTestValueType>();
    private StandardTestValueType contextValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType messagesValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType fragmentValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType inputValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType inputCacheableValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType cacheValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType nameValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType outputValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType templateModeValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType outputThrowableClassValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType outputThrowableMessagePatternValueType = StandardTestValueType.NO_VALUE;
    private StandardTestValueType exactMatchValueType = StandardTestValueType.NO_VALUE;

    @Override
    public final void setOutput(ITestResource output) {
        this.setOutput(output, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setOutputThrowableClass(Class<? extends Throwable> outputThrowableClass) {
        this.setOutputThrowableClass(outputThrowableClass, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setOutputThrowableMessagePattern(String outputThrowableMessagePattern) {
        this.setOutputThrowableMessagePattern(outputThrowableMessagePattern, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setContext(ITestContext context) {
        this.setContext(context, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setMessages(ITestMessages messages) {
        this.setMessages(messages, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setTemplateMode(String templateMode) {
        this.setTemplateMode(templateMode, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setFragmentSpec(IFragmentSpec fragmentSpec) {
        this.setFragmentSpec(fragmentSpec, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setInput(ITestResource input) {
        this.setInput(input, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setAdditionalInputs(Map<String, ITestResource> additionalInputs) {
        this.setAdditionalInputs(additionalInputs, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setAdditionalInput(String name, ITestResource resource) {
        this.setAdditionalInput(name, resource, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setInputCacheable(boolean inputCacheale) {
        this.setInputCacheable(inputCacheale, DEFAULT_VALUE_TYPE);
    }

    @Override
    public final void setName(String name) {
        this.setName(name, DEFAULT_VALUE_TYPE);
    }

    public void setOutput(ITestResource output, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setOutput(output);
        this.outputValueType = valueType;
    }

    public void setOutputThrowableClass(Class<? extends Throwable> outputThrowableClass, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setOutputThrowableClass(outputThrowableClass);
        this.outputThrowableClassValueType = valueType;
    }

    public void setOutputThrowableMessagePattern(String outputThrowableMessagePattern, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setOutputThrowableMessagePattern(outputThrowableMessagePattern);
        this.outputThrowableMessagePatternValueType = valueType;
    }

    public void setContext(ITestContext context, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setContext(context);
        this.contextValueType = valueType;
    }

    public void setMessages(ITestMessages messages, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setMessages(messages);
        this.messagesValueType = valueType;
    }

    public void setTemplateMode(String templateMode, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setTemplateMode(templateMode);
        this.templateModeValueType = valueType;
    }

    public void setFragmentSpec(IFragmentSpec fragmentSpec, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setFragmentSpec(fragmentSpec);
        this.fragmentValueType = valueType;
    }

    public void setInput(ITestResource input, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setInput(input);
        this.inputValueType = valueType;
    }

    public void setAdditionalInputs(Map<String, ITestResource> additionalInputs, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setAdditionalInputs(additionalInputs);
        if (additionalInputs != null) {
            for (String inputName : additionalInputs.keySet()) {
                this.additionalInputsValueTypes.put(inputName, valueType);
            }
        }
    }

    public void setAdditionalInput(String name, ITestResource resource, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setAdditionalInput(name, resource);
        this.additionalInputsValueTypes.put(name, valueType);
    }

    public void setInputCacheable(boolean inputCacheale, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setInputCacheable(inputCacheale);
        this.inputCacheableValueType = valueType;
    }

    public void setName(String name, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setName(name);
        this.nameValueType = valueType;
    }

    public void setExactMatch(boolean exactMatch, StandardTestValueType valueType) {
        Validate.notNull((Object)((Object)valueType), (String)"Value type cannot be null");
        super.setExactMatch(exactMatch);
        this.exactMatchValueType = valueType;
    }

    public Map<String, StandardTestValueType> getAdditionalInputsValueTypes() {
        return Collections.unmodifiableMap(this.additionalInputsValueTypes);
    }

    public StandardTestValueType getAdditionalInputsValueTypes(String inputName) {
        return this.additionalInputsValueTypes.get(inputName);
    }

    public StandardTestValueType getContextValueType() {
        return this.contextValueType;
    }

    public StandardTestValueType getMessagesValueType() {
        return this.messagesValueType;
    }

    public StandardTestValueType getFragmentValueType() {
        return this.fragmentValueType;
    }

    public StandardTestValueType getInputValueType() {
        return this.inputValueType;
    }

    public StandardTestValueType getInputCacheableValueType() {
        return this.inputCacheableValueType;
    }

    public StandardTestValueType getCacheValueType() {
        return this.cacheValueType;
    }

    public StandardTestValueType getNameValueType() {
        return this.nameValueType;
    }

    public StandardTestValueType getOutputValueType() {
        return this.outputValueType;
    }

    public StandardTestValueType getTemplateModeValueType() {
        return this.templateModeValueType;
    }

    public StandardTestValueType getOutputThrowableClassValueType() {
        return this.outputThrowableClassValueType;
    }

    public StandardTestValueType getOutputThrowableMessagePatternValueType() {
        return this.outputThrowableMessagePatternValueType;
    }

    public StandardTestValueType getExactMatchValueType() {
        return this.exactMatchValueType;
    }
}

