/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.resolver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.resolver.ITestableResolver;
import org.thymeleaf.testing.templateengine.standard.test.builder.IStandardTestBuilder;
import org.thymeleaf.testing.templateengine.standard.test.builder.StandardTestBuilder;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedData;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestRawData;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.IStandardTestEvaluator;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.StandardTestEvaluator;
import org.thymeleaf.testing.templateengine.standard.test.reader.IStandardTestReader;
import org.thymeleaf.testing.templateengine.standard.test.reader.StandardTestReader;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.testable.ITestIterator;
import org.thymeleaf.testing.templateengine.testable.ITestParallelizer;
import org.thymeleaf.testing.templateengine.testable.ITestSequence;
import org.thymeleaf.testing.templateengine.testable.ITestable;
import org.thymeleaf.testing.templateengine.testable.TestIterator;
import org.thymeleaf.testing.templateengine.testable.TestParallelizer;
import org.thymeleaf.testing.templateengine.testable.TestSequence;
import org.thymeleaf.util.Validate;

public abstract class AbstractStandardLocalFileTestableResolver
implements ITestableResolver {
    public static final String FOLDER_INDEX_FILE_PREFIX = "FOLDER";
    private static String TEST_FILE_SUFFIX = ".THTEST";
    private static String INDEX_FILE_SUFFIX = ".THINDEX";
    public static final String FOLDER_INDEX_FILE_NAME = "FOLDER" + INDEX_FILE_SUFFIX;
    private static final Pattern INDEX_FILE_LINE_PATTERN = Pattern.compile("(.*?)(\\[(.*?)])?\\s*$");
    private static String ITERATOR_SUFFIX_PATTERN_STR = "iter-(\\d*)$";
    private static String ITERATOR_PATTERN_STR = "^(.*?)-" + ITERATOR_SUFFIX_PATTERN_STR;
    private static Pattern ITERATOR_SUFFIX_PATTERN = Pattern.compile(ITERATOR_SUFFIX_PATTERN_STR);
    private static Pattern ITERATOR_PATTERN = Pattern.compile(ITERATOR_PATTERN_STR);
    private static String PARALLELIZER_SUFFIX_PATTERN_STR = "parallel-(\\d*)$";
    private static String PARALLELIZER_PATTERN_STR = "^(.*?)-" + PARALLELIZER_SUFFIX_PATTERN_STR;
    private static Pattern PARALLELIZER_SUFFIX_PATTERN = Pattern.compile(PARALLELIZER_SUFFIX_PATTERN_STR);
    private static Pattern PARALLELIZER_PATTERN = Pattern.compile(PARALLELIZER_PATTERN_STR);
    private IStandardTestReader testReader = new StandardTestReader();
    private IStandardTestEvaluator testEvaluator = new StandardTestEvaluator();
    private IStandardTestBuilder testBuilder = new StandardTestBuilder(this);

    protected AbstractStandardLocalFileTestableResolver() {
    }

    public IStandardTestBuilder getTestBuilder() {
        return this.testBuilder;
    }

    public void setTestBuilder(IStandardTestBuilder testBuilder) {
        Validate.notNull((Object)testBuilder, (String)"Test Builder cannot be null");
        this.testBuilder = testBuilder;
    }

    public IStandardTestReader getTestReader() {
        return this.testReader;
    }

    public void setTestReader(IStandardTestReader testReader) {
        Validate.notNull((Object)testReader, (String)"Test Reader cannot be null");
        this.testReader = testReader;
    }

    public IStandardTestEvaluator getTestEvaluator() {
        return this.testEvaluator;
    }

    public void setTestEvaluator(IStandardTestEvaluator testEvaluator) {
        Validate.notNull((Object)testEvaluator, (String)"Test Evaluator cannot be null");
        this.testEvaluator = testEvaluator;
    }

    public final ITestable resolve(String executionId, String testableName) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)testableName, (String)"Testable name cannot be null");
        File testableFile = this.getFileFromTestableName(executionId, testableName);
        if (testableFile == null) {
            return null;
        }
        return this.resolveFile(executionId, testableFile);
    }

    protected TestableType computeTestableTypeFromFileName(String fileName, boolean isDirectory) {
        if (fileName == null) {
            return TestableType.NONE;
        }
        if (!isDirectory) {
            if (fileName.toUpperCase().endsWith(TEST_FILE_SUFFIX)) {
                return TestableType.TEST;
            }
            if (fileName.toUpperCase().endsWith(INDEX_FILE_SUFFIX)) {
                return TestableType.SEQUENCE;
            }
            return TestableType.NONE;
        }
        Matcher iterMatcher = ITERATOR_PATTERN.matcher(fileName);
        if (iterMatcher.matches()) {
            return TestableType.ITERATOR;
        }
        Matcher paralMatcher = PARALLELIZER_PATTERN.matcher(fileName);
        if (paralMatcher.matches()) {
            return TestableType.PARALLELIZER;
        }
        return TestableType.SEQUENCE;
    }

    protected abstract File getFileFromTestableName(String var1, String var2);

    protected final ITestable resolveFile(String executionId, File file) {
        if (file == null) {
            return null;
        }
        String fileName = file.getName();
        boolean isDirectory = file.isDirectory();
        if (!isDirectory && !file.isFile()) {
            return null;
        }
        TestableType type = this.computeTestableTypeFromFileName(fileName, isDirectory);
        if (type == null) {
            return null;
        }
        switch (type) {
            case TEST: {
                return this.resolveAsTest(executionId, file);
            }
            case SEQUENCE: {
                return this.resolveAsTestSequence(executionId, file);
            }
            case ITERATOR: {
                return this.resolveAsTestIterator(executionId, file);
            }
            case PARALLELIZER: {
                return this.resolveAsTestParallelizer(executionId, file);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Cannot process testable type " + (Object)((Object)type));
    }

    protected final ITest resolveAsTest(String executionId, File file) {
        StandardTestRawData rawData;
        FileReader documentReader;
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)file, (String)"Test document file cannot be null");
        String documentName = file.getName();
        IStandardTestReader reader = this.getTestReader();
        if (reader == null) {
            throw new TestEngineExecutionException("A null test reader has been configured");
        }
        IStandardTestEvaluator evaluator = this.getTestEvaluator();
        if (evaluator == null) {
            throw new TestEngineExecutionException("A null test evaluator has been configured");
        }
        IStandardTestBuilder builder = this.getTestBuilder();
        if (builder == null) {
            throw new TestEngineExecutionException("A null test builder has been configured");
        }
        try {
            documentReader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            throw new TestEngineExecutionException("Test file \"" + file.getAbsolutePath() + "\" does not exist");
        }
        try {
            rawData = reader.readTestDocument(executionId, documentName, documentReader);
        }
        catch (IOException e) {
            throw new TestEngineExecutionException("Error reading document \"" + documentName + "\"", e);
        }
        StandardTestEvaluatedData evaluatedData = evaluator.evaluateTestData(executionId, rawData);
        return builder.buildTest(executionId, evaluatedData);
    }

    protected ITestSequence resolveAsTestSequence(String executionId, File file) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)file, (String)"File cannot be null");
        String fileName = file.getName();
        TestSequence testSequence = new TestSequence();
        testSequence.setName(fileName);
        File indexFile = null;
        if (!file.isDirectory()) {
            if (!file.isFile()) {
                return null;
            }
            if (file.getName().toUpperCase().endsWith(INDEX_FILE_SUFFIX)) {
                indexFile = file;
            } else {
                return null;
            }
        }
        if (indexFile == null) {
            for (File fileInFolder : file.listFiles()) {
                if (!FOLDER_INDEX_FILE_NAME.equalsIgnoreCase(fileInFolder.getName())) continue;
                indexFile = fileInFolder;
                break;
            }
        }
        if (indexFile == null) {
            for (File fileInFolder : file.listFiles()) {
                ITestable testable = this.resolveFile(executionId, fileInFolder);
                if (testable == null) continue;
                testSequence.addElement(testable);
            }
            return testSequence;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(indexFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("") || line.startsWith("#")) continue;
                String[] lineComponents = AbstractStandardLocalFileTestableResolver.parseTestIndexLine(line);
                if (lineComponents == null) {
                    throw new TestEngineExecutionException("Error parsing test index file line: '" + line + "'");
                }
                String testFileName = lineComponents[0];
                String testSpec = lineComponents[1];
                File testFile = new File((indexFile.getParentFile() != null ? indexFile.getParentFile().getAbsolutePath() : "") + File.separator + testFileName);
                ITestable testable = this.resolveFile(executionId, testFile);
                if (testable == null) {
                    throw new TestEngineExecutionException("Error resolving file '" + testFileName + "' " + "specified in test index file: '" + indexFile.getAbsolutePath() + "'");
                }
                if (testSpec != null) {
                    Matcher iterMatcher = ITERATOR_SUFFIX_PATTERN.matcher(testSpec);
                    if (iterMatcher.matches()) {
                        int iterations = Integer.parseInt(iterMatcher.group(1));
                        TestIterator testIterator = new TestIterator(testable, iterations);
                        testable = testIterator;
                    } else {
                        Matcher parMatcher = PARALLELIZER_SUFFIX_PATTERN.matcher(testSpec);
                        if (parMatcher.matches()) {
                            int numThreads = Integer.parseInt(parMatcher.group(1));
                            TestParallelizer testParallelizer = new TestParallelizer(testable, numThreads);
                            testable = testParallelizer;
                        } else {
                            throw new TestEngineExecutionException("Error resolving file '" + testFileName + "' " + "specified in test index file: '" + indexFile.getAbsolutePath() + "'. " + "Unrecognized specification '[" + testSpec + "]'");
                        }
                    }
                }
                testSequence.addElement(testable);
            }
            TestSequence testSequence2 = testSequence;
            return testSequence2;
        }
        catch (Exception e) {
            throw new TestEngineExecutionException("Exception raised while reading test index file '" + indexFile.getAbsolutePath() + "'", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String[] parseTestIndexLine(String line) {
        Matcher m;
        if (line == null) {
            return null;
        }
        Pattern pattern = INDEX_FILE_LINE_PATTERN;
        synchronized (pattern) {
            m = INDEX_FILE_LINE_PATTERN.matcher(line);
        }
        if (m == null || !m.matches()) {
            return null;
        }
        String fileName = m.group(1);
        String lineSpec = m.group(3);
        if (fileName == null || fileName.trim().equals("")) {
            return null;
        }
        String[] result = new String[]{fileName.trim(), lineSpec == null ? null : lineSpec.trim()};
        return result;
    }

    protected ITestIterator resolveAsTestIterator(String executionId, File file) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)file, (String)"File cannot be null");
        String fileName = file.getName();
        Matcher iterMatcher = ITERATOR_PATTERN.matcher(fileName);
        if (!iterMatcher.matches()) {
            throw new TestEngineExecutionException("Cannot match \"" + fileName + "\" as a valid folder name for an iterator");
        }
        int iterations = Integer.parseInt(iterMatcher.group(2));
        ITestSequence iteratedSequence = this.resolveAsTestSequence(executionId, file);
        return new TestIterator(iteratedSequence, iterations);
    }

    protected ITestParallelizer resolveAsTestParallelizer(String executionId, File file) {
        Validate.notNull((Object)executionId, (String)"Execution ID cannot be null");
        Validate.notNull((Object)file, (String)"File cannot be null");
        String fileName = file.getName();
        Matcher parMatcher = PARALLELIZER_PATTERN.matcher(fileName);
        if (!parMatcher.matches()) {
            throw new TestEngineExecutionException("Cannot match \"" + fileName + "\" as a valid folder name for a parallelizer");
        }
        int numThreads = Integer.parseInt(parMatcher.group(2));
        ITestSequence iteratedSequence = this.resolveAsTestSequence(executionId, file);
        return new TestParallelizer(iteratedSequence, numThreads);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TestableType {
        NONE,
        TEST,
        SEQUENCE,
        ITERATOR,
        PARALLELIZER;

    }
}

