/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.expression.ExpressionEvaluatorObjects;
import org.thymeleaf.testing.templateengine.context.ITestContextExpression;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OgnlTestContextExpression
implements ITestContextExpression {
    private final String expression;

    public OgnlTestContextExpression(String expression) {
        Validate.notNull((Object)expression, (String)"Expression cannot be null or empty");
        this.expression = expression.trim().equals("") ? "''" : expression;
    }

    @Override
    public Object evaluate(Map<String, Object> context, Locale locale) {
        HashMap contextVariables = new HashMap();
        Map expressionUtilityObjects = ExpressionEvaluatorObjects.getExpressionEvaluationUtilityObjectsForLocale((Locale)locale);
        if (expressionUtilityObjects != null) {
            contextVariables.putAll(expressionUtilityObjects);
        }
        try {
            Object varExpression = Ognl.parseExpression((String)this.expression);
            return Ognl.getValue((Object)varExpression, contextVariables, context);
        }
        catch (OgnlException e) {
            throw new TemplateProcessingException("Exception evaluating OGNL expression: \"" + this.expression + "\"", (Throwable)e);
        }
    }
}

