/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.exceptions.TemplateProcessingException;

public final class SpringStandardExpressions {
    public static final String ENABLE_SPRING_EL_COMPILER_ATTRIBUTE_NAME = "EnableSpringELCompiler";

    private SpringStandardExpressions() {
    }

    public static boolean isSpringELCompilerEnabled(IEngineConfiguration configuration) {
        Object enableSpringELCompiler = configuration.getExecutionAttributes().get(ENABLE_SPRING_EL_COMPILER_ATTRIBUTE_NAME);
        if (enableSpringELCompiler == null) {
            return false;
        }
        if (!(enableSpringELCompiler instanceof Boolean)) {
            throw new TemplateProcessingException("A value for the \"EnableSpringELCompiler\" execution attribute has been specified, but it is not of the required type Boolean. (" + enableSpringELCompiler.getClass().getName() + ")");
        }
        return (Boolean)enableSpringELCompiler;
    }
}

