/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.templateresource;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.thymeleaf.templateresource.ITemplateResource;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class SpringResourceTemplateResource
implements ITemplateResource {
    private final Resource resource;
    private final String characterEncoding;

    public SpringResourceTemplateResource(ApplicationContext applicationContext, String location, String characterEncoding) {
        Validate.notNull((Object)applicationContext, (String)"Application Context cannot be null");
        Validate.notEmpty((String)location, (String)"Resource Location cannot be null or empty");
        this.resource = applicationContext.getResource(location);
        this.characterEncoding = characterEncoding;
    }

    public SpringResourceTemplateResource(Resource resource, String characterEncoding) {
        Validate.notNull((Object)resource, (String)"Resource cannot be null");
        this.resource = resource;
        this.characterEncoding = characterEncoding;
    }

    public String getDescription() {
        return this.resource.getDescription();
    }

    public String getBaseName() {
        return SpringResourceTemplateResource.computeBaseName(this.resource.getFilename());
    }

    public boolean exists() {
        return this.resource.exists();
    }

    public Reader reader() throws IOException {
        InputStream inputStream = this.resource.getInputStream();
        if (!StringUtils.isEmptyOrWhitespace((String)this.characterEncoding)) {
            return new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(inputStream), this.characterEncoding));
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(inputStream)));
    }

    public ITemplateResource relative(String relativeLocation) throws IOException {
        return new SpringResourceTemplateResource(this.resource.createRelative(relativeLocation), this.characterEncoding);
    }

    static String computeBaseName(String path) {
        if (path == null) {
            return null;
        }
        String basePath = path.charAt(path.length() - 1) == '/' ? path.substring(0, path.length() - 1) : path;
        int slashPos = basePath.lastIndexOf(47);
        if (slashPos != -1) {
            int dotPos = basePath.lastIndexOf(46);
            if (dotPos != -1 && dotPos > slashPos + 1) {
                return basePath.substring(slashPos + 1, dotPos);
            }
            return basePath.substring(slashPos + 1);
        }
        return basePath;
    }
}

