/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring4.processor.AbstractSpringFieldTagProcessor;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.unbescape.html.HtmlEscape;

public final class SpringInputRadioFieldTagProcessor
extends AbstractSpringFieldTagProcessor {
    public static final String RADIO_INPUT_TYPE_ATTR_VALUE = "radio";

    public SpringInputRadioFieldTagProcessor(IProcessorDialect dialect, String dialectPrefix) {
        super(dialect, dialectPrefix, "input", "type", new String[]{RADIO_INPUT_TYPE_ATTR_VALUE}, true);
    }

    protected void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, String attributeTemplateName, int attributeLine, int attributeCol, BindStatus bindStatus, IElementTagStructureHandler structureHandler) {
        String name = bindStatus.getExpression();
        name = name == null ? "" : name;
        String id = this.computeId(context, tag, name, true);
        String value = tag.getAttributes().getValue("value");
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"input(radio)\" tags");
        }
        boolean checked = SelectedValueComparatorWrapper.isSelected(bindStatus, HtmlEscape.unescapeHtml((String)value));
        tag.getAttributes().setAttribute("id", id);
        tag.getAttributes().setAttribute("name", name);
        tag.getAttributes().setAttribute("value", RequestDataValueProcessorUtils.processFormFieldValue(context, name, value, RADIO_INPUT_TYPE_ATTR_VALUE));
        if (checked) {
            tag.getAttributes().setAttribute("checked", "checked");
        } else {
            tag.getAttributes().removeAttribute("checked");
        }
    }
}

