/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.thymeleaf.expression.IExpressionObjects;
import org.thymeleaf.spring4.expression.IThymeleafEvaluationContext;
import org.thymeleaf.spring4.expression.SPELVariablesMapPropertyAccessor;
import org.thymeleaf.util.Validate;

public final class ThymeleafEvaluationContext
extends StandardEvaluationContext
implements IThymeleafEvaluationContext {
    public static final String THYMELEAF_EVALUATION_CONTEXT_CONTEXT_VARIABLE_NAME = "thymeleaf::EvaluationContext";
    private static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();
    private IExpressionObjects expressionObjects = null;
    private boolean variableAccessRestricted = false;

    public ThymeleafEvaluationContext(BeanFactory beanFactory, ConversionService conversionService) {
        Validate.notNull((Object)beanFactory, (String)"Bean factory cannot be null");
        this.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        if (conversionService != null) {
            this.setTypeConverter((TypeConverter)new StandardTypeConverter(conversionService));
        }
        this.addPropertyAccessor(SPELVariablesMapPropertyAccessor.INSTANCE);
        this.addPropertyAccessor((PropertyAccessor)MAP_ACCESSOR_INSTANCE);
    }

    public Object lookupVariable(String name) {
        Object result;
        if (this.expressionObjects != null && this.expressionObjects.containsObject(name) && (result = this.expressionObjects.getObject(name)) != null) {
            return result;
        }
        return super.lookupVariable(name);
    }

    public boolean isVariableAccessRestricted() {
        return this.variableAccessRestricted;
    }

    public void setVariableAccessRestricted(boolean restricted) {
        this.variableAccessRestricted = restricted;
    }

    public IExpressionObjects getExpressionObjects() {
        return this.expressionObjects;
    }

    public void setExpressionObjects(IExpressionObjects expressionObjects) {
        this.expressionObjects = expressionObjects;
    }
}

