/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.expression;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.expression.ExpressionObjectDefinition;
import org.thymeleaf.spring4.expression.Fields;
import org.thymeleaf.spring4.expression.Mvc;
import org.thymeleaf.spring4.expression.Themes;
import org.thymeleaf.standard.expression.StandardExpressionObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringStandardExpressionObjectFactory
extends StandardExpressionObjectFactory {
    public static final String FIELDS_EXPRESSION_OBJECT_NAME = "fields";
    public static final String FIELDS_EXPRESSION_OBJECT_DESCRIPTION = "Access to form field errors and binding info";
    public static final boolean FIELDS_EXPRESSION_OBJECT_CACHEABLE = true;
    public static final ExpressionObjectDefinition FIELDS_EXPRESSION_OBJECT_DEFINITION = new ExpressionObjectDefinition("fields", "Access to form field errors and binding info", true);
    public static final String THEMES_EXPRESSION_OBJECT_NAME = "themes";
    public static final String THEMES_EXPRESSION_OBJECT_DESCRIPTION = "Spring MVC themes operation";
    public static final boolean THEMES_EXPRESSION_OBJECT_CACHEABLE = true;
    public static final ExpressionObjectDefinition THEMES_EXPRESSION_OBJECT_DEFINITION = new ExpressionObjectDefinition("themes", "Spring MVC themes operation", true);
    public static final String MVC_EXPRESSION_OBJECT_NAME = "mvc";
    public static final String MVC_EXPRESSION_OBJECT_DESCRIPTION = "Creation of Spring MVC controller-bound URLs with MvcUriComponentsBuilder";
    public static final boolean MVC_EXPRESSION_OBJECT_CACHEABLE = true;
    public static final ExpressionObjectDefinition MVC_EXPRESSION_OBJECT_DEFINITION = new ExpressionObjectDefinition("mvc", "Creation of Spring MVC controller-bound URLs with MvcUriComponentsBuilder", true);
    public static final Map<String, ExpressionObjectDefinition> ALL_EXPRESSION_OBJECT_DEFINITIONS;
    private static final Mvc MVC_EXPRESSION_OBJECT;

    public Map<String, ExpressionObjectDefinition> getObjectDefinitions() {
        return ALL_EXPRESSION_OBJECT_DEFINITIONS;
    }

    public Object buildObject(IProcessingContext processingContext, String expressionObjectName) {
        if (MVC_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            return MVC_EXPRESSION_OBJECT;
        }
        if (THEMES_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            return new Themes(processingContext);
        }
        if (FIELDS_EXPRESSION_OBJECT_NAME.equals(expressionObjectName)) {
            return new Fields(processingContext);
        }
        return super.buildObject(processingContext, expressionObjectName);
    }

    static {
        MVC_EXPRESSION_OBJECT = new Mvc();
        LinkedHashMap<String, ExpressionObjectDefinition> allExpressionObjectDefinitions = new LinkedHashMap<String, ExpressionObjectDefinition>();
        allExpressionObjectDefinitions.putAll(StandardExpressionObjectFactory.ALL_EXPRESSION_OBJECT_DEFINITIONS);
        allExpressionObjectDefinitions.put(FIELDS_EXPRESSION_OBJECT_NAME, FIELDS_EXPRESSION_OBJECT_DEFINITION);
        allExpressionObjectDefinitions.put(THEMES_EXPRESSION_OBJECT_NAME, THEMES_EXPRESSION_OBJECT_DEFINITION);
        allExpressionObjectDefinitions.put(MVC_EXPRESSION_OBJECT_NAME, MVC_EXPRESSION_OBJECT_DEFINITION);
        ALL_EXPRESSION_OBJECT_DEFINITIONS = Collections.unmodifiableMap(allExpressionObjectDefinitions);
    }
}

