/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.resourceresolver;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.thymeleaf.IEngineConfiguration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IContext;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.resource.IResource;
import org.thymeleaf.resource.ReaderResource;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.util.StringUtils;
import org.thymeleaf.util.Validate;

public final class SpringResourceResourceResolver
implements IResourceResolver,
ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringResourceResourceResolver.class);
    public static final String NAME = "SPRING-RESOURCE";
    private ApplicationContext applicationContext = null;

    public String getName() {
        return NAME;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public IResource resolveResource(IEngineConfiguration configuration, IContext context, String resource, String characterEncoding) {
        Validate.notNull((Object)resource, (String)"Resource name cannot be null");
        Validate.notNull((Object)this.applicationContext, (String)"ApplicationContext has not been initialized in resource resolver. TemplateResolver or ResourceResolver might not have been correctly configured by the Spring Application Context.");
        try {
            Resource resourceObject = this.applicationContext.getResource(resource);
            if (resourceObject == null) {
                return null;
            }
            InputStream inputStream = resourceObject.getInputStream();
            if (inputStream == null) {
                return null;
            }
            InputStreamReader reader = !StringUtils.isEmptyOrWhitespace((String)characterEncoding) ? new InputStreamReader(inputStream, characterEncoding) : new InputStreamReader(inputStream);
            return new ReaderResource(resource, (Reader)reader);
        }
        catch (UnsupportedEncodingException e) {
            throw new TemplateInputException("Exception reading resource: " + resource, (Throwable)e);
        }
        catch (Throwable t) {
            SpringResourceResourceResolver.showException(resource, t);
            return null;
        }
    }

    private static void showException(String resourceName, Throwable t) {
        if (logger.isDebugEnabled()) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("[THYMELEAF][%s] Resource \"%s\" could not be resolved. This can be normal as maybe this resource is not intended to be resolved by this resolver. Exception is provided for tracing purposes: ", TemplateEngine.threadIndex(), resourceName), t);
            } else {
                logger.debug(String.format("[THYMELEAF][%s] Resource \"%s\" could not be resolved. This can be normal as maybe this resource is not intended to be resolved by this resolver. Exception message is provided (set the log to TRACE for the entire trace): %s: %s", TemplateEngine.threadIndex(), resourceName, t.getClass().getName(), t.getMessage()));
            }
        }
    }
}

