/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor;

import java.util.Map;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.context.ITemplateProcessingContext;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IElementStructureHandler;
import org.thymeleaf.engine.IMarkup;
import org.thymeleaf.engine.ITemplateHandlerEvent;
import org.thymeleaf.engine.Markup;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.spring4.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public final class SpringActionTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 1000;
    public static final String ATTR_NAME = "action";

    public SpringActionTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, ATTR_NAME, 1000);
    }

    protected final void doProcess(ITemplateProcessingContext processingContext, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementStructureHandler structureHandler) {
        Map<String, String> extraHiddenFields;
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? "" : expressionResult.toString()));
        String httpMethod = tag.getAttributes().getValue("method");
        newAttributeValue = RequestDataValueProcessorUtils.processAction((IProcessingContext)processingContext, newAttributeValue, httpMethod);
        tag.getAttributes().setAttribute(ATTR_NAME, newAttributeValue == null ? "" : newAttributeValue);
        tag.getAttributes().removeAttribute(attributeName);
        if ("form".equalsIgnoreCase(tag.getElementName()) && (extraHiddenFields = RequestDataValueProcessorUtils.getExtraHiddenFields((IProcessingContext)processingContext)) != null && extraHiddenFields.size() > 0) {
            Markup extraHiddenElementTags = processingContext.getMarkupFactory().createMarkup();
            for (Map.Entry<String, String> extraHiddenField : extraHiddenFields.entrySet()) {
                IStandaloneElementTag extraHiddenElementTag = processingContext.getMarkupFactory().createStandaloneElementTag("input", true);
                extraHiddenElementTag.getAttributes().setAttribute("type", "hidden");
                extraHiddenElementTag.getAttributes().setAttribute("name", extraHiddenField.getKey());
                extraHiddenElementTag.getAttributes().setAttribute("value", extraHiddenField.getValue());
                extraHiddenElementTags.add((ITemplateHandlerEvent)extraHiddenElementTag);
            }
            structureHandler.insertAfter((IMarkup)extraHiddenElementTags, false);
        }
    }
}

