/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.dialect;

import java.util.LinkedHashSet;
import java.util.Set;
import org.thymeleaf.expression.IExpressionObjectFactory;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.spring4.expression.SPELVariableExpressionEvaluator;
import org.thymeleaf.spring4.expression.SpringStandardConversionService;
import org.thymeleaf.spring4.expression.SpringStandardExpressionObjectFactory;
import org.thymeleaf.spring4.processor.SpringActionTagProcessor;
import org.thymeleaf.spring4.processor.SpringErrorClassTagProcessor;
import org.thymeleaf.spring4.processor.SpringErrorsTagProcessor;
import org.thymeleaf.spring4.processor.SpringHrefTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputCheckboxFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputFileFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputGeneralFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputPasswordFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringInputRadioFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringMethodTagProcessor;
import org.thymeleaf.spring4.processor.SpringObjectTagProcessor;
import org.thymeleaf.spring4.processor.SpringOptionFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringOptionInSelectFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringSelectFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringSrcTagProcessor;
import org.thymeleaf.spring4.processor.SpringTextareaFieldTagProcessor;
import org.thymeleaf.spring4.processor.SpringTranslationDocTypeProcessor;
import org.thymeleaf.spring4.processor.SpringValueTagProcessor;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardConversionService;
import org.thymeleaf.standard.expression.IStandardVariableExpressionEvaluator;
import org.thymeleaf.standard.processor.StandardActionTagProcessor;
import org.thymeleaf.standard.processor.StandardHrefTagProcessor;
import org.thymeleaf.standard.processor.StandardMethodTagProcessor;
import org.thymeleaf.standard.processor.StandardObjectTagProcessor;
import org.thymeleaf.standard.processor.StandardSrcTagProcessor;
import org.thymeleaf.standard.processor.StandardValueTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringStandardDialect
extends StandardDialect {
    private static final String NAME = "SpringStandard";
    private static final String PREFIX = "th";
    private final IExpressionObjectFactory SPRING_STANDARD_EXPRESSION_OBJECTS_FACTORY = new SpringStandardExpressionObjectFactory();
    private final IStandardConversionService SPRING_STANDARD_CONVERSION_SERVICE = new SpringStandardConversionService();

    public SpringStandardDialect() {
        super(NAME, PREFIX);
    }

    public IStandardVariableExpressionEvaluator getVariableExpressionEvaluator() {
        return SPELVariableExpressionEvaluator.INSTANCE;
    }

    public IStandardConversionService getConversionService() {
        return this.SPRING_STANDARD_CONVERSION_SERVICE;
    }

    public IExpressionObjectFactory getExpressionObjectFactory() {
        return this.SPRING_STANDARD_EXPRESSION_OBJECTS_FACTORY;
    }

    public Set<IProcessor> getProcessors(String dialectPrefix) {
        return SpringStandardDialect.createSpringStandardProcessorsSet(dialectPrefix);
    }

    public static Set<IProcessor> createSpringStandardProcessorsSet(String dialectPrefix) {
        Set standardProcessors = StandardDialect.createStandardProcessorsSet((String)dialectPrefix);
        LinkedHashSet<IProcessor> processors = new LinkedHashSet<IProcessor>(40);
        for (IProcessor standardProcessor : standardProcessors) {
            if (!(standardProcessor instanceof StandardObjectTagProcessor || standardProcessor instanceof StandardActionTagProcessor || standardProcessor instanceof StandardHrefTagProcessor || standardProcessor instanceof StandardMethodTagProcessor || standardProcessor instanceof StandardSrcTagProcessor || standardProcessor instanceof StandardValueTagProcessor)) {
                processors.add(standardProcessor);
                continue;
            }
            if (standardProcessor.getTemplateMode() == TemplateMode.HTML) continue;
            processors.add(standardProcessor);
        }
        processors.add((IProcessor)new SpringActionTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringHrefTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringMethodTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringSrcTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringValueTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringObjectTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringErrorsTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputGeneralFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputPasswordFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputCheckboxFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputRadioFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringInputFileFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringSelectFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringOptionInSelectFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringOptionFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringTextareaFieldTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringErrorClassTagProcessor(dialectPrefix));
        processors.add((IProcessor)new SpringTranslationDocTypeProcessor());
        return processors;
    }
}

