/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.processor.attr;

import java.util.Map;
import org.springframework.web.servlet.support.BindStatus;
import org.springframework.web.servlet.tags.form.SelectedValueComparatorWrapper;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.spring4.processor.attr.AbstractSpringFieldAttrProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpringOptionFieldAttrProcessor
extends AbstractSpringFieldAttrProcessor {
    public SpringOptionFieldAttrProcessor() {
        super("field", "option");
    }

    @Override
    protected ProcessorResult doProcess(Arguments arguments, Element element, String attributeName, String attributeValue, BindStatus bindStatus, Map<String, Object> localVariables) {
        String value = element.getAttributeValue("value");
        if (value == null) {
            throw new TemplateProcessingException("Attribute \"value\" is required in \"option\" tags");
        }
        boolean selected = SelectedValueComparatorWrapper.isSelected(bindStatus, value);
        element.setAttribute("value", value);
        if (selected) {
            element.setAttribute("selected", "selected");
        } else {
            element.removeAttribute("selected");
        }
        element.removeAttribute(attributeName);
        return ProcessorResult.setLocalVariables(localVariables);
    }
}

