/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.messageresolver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.NoSuchMessageException;
import org.thymeleaf.Arguments;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.messageresolver.AbstractMessageResolver;
import org.thymeleaf.messageresolver.MessageResolution;
import org.thymeleaf.util.Validate;

public final class SpringNonCacheableMessageResolver
extends AbstractMessageResolver
implements MessageSourceAware {
    private static final Logger logger = LoggerFactory.getLogger(SpringNonCacheableMessageResolver.class);
    private MessageSource messageSource;

    protected final void initializeSpecific() {
        if (this.messageSource == null) {
            throw new ConfigurationException("Cannot initialize " + SpringNonCacheableMessageResolver.class.getSimpleName() + ": MessageSource has not been set. Either define this object as " + "a Spring bean (which will automatically set the MessageSource) or, " + "if you instance it directly, set the MessageSource manually using its " + "corresponding setter method.");
        }
        this.initializeSpringSpecific();
    }

    protected void initializeSpringSpecific() {
    }

    public final MessageSource getMessageSource() {
        this.checkInitialized();
        return this.messageSource;
    }

    protected final MessageSource unsafeGetMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.checkNotInitialized();
        this.messageSource = messageSource;
    }

    public MessageResolution resolveMessage(Arguments arguments, String key, Object[] messageParameters) {
        Validate.notNull((Object)arguments, (String)"Arguments cannot be null");
        Validate.notNull((Object)arguments.getContext().getLocale(), (String)"Locale in context cannot be null");
        Validate.notNull((Object)key, (String)"Message key cannot be null");
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Resolving message with key \"{}\" for template \"{}\" and locale \"{}\". Messages will be retrieved from Spring's MessageSource infrastructure.", new Object[]{TemplateEngine.threadIndex(), key, arguments.getTemplateName(), arguments.getContext().getLocale()});
        }
        try {
            String resolvedMessage = this.messageSource.getMessage(key, messageParameters, arguments.getContext().getLocale());
            return new MessageResolution(resolvedMessage);
        }
        catch (NoSuchMessageException e) {
            return null;
        }
    }
}

