/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.view;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.js.ajax.AjaxHandler;
import org.springframework.util.StringUtils;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.spring3.view.AjaxEnabledView;
import org.thymeleaf.spring3.view.ThymeleafView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AjaxThymeleafView
extends ThymeleafView
implements AjaxEnabledView {
    private static final Logger vlogger = LoggerFactory.getLogger(AjaxThymeleafView.class);
    private static final String FRAGMENTS_PARAM = "fragments";
    private AjaxHandler ajaxHandler = null;

    @Override
    public AjaxHandler getAjaxHandler() {
        return this.ajaxHandler;
    }

    @Override
    public void setAjaxHandler(AjaxHandler ajaxHandler) {
        this.ajaxHandler = ajaxHandler;
    }

    @Override
    public void render(Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxHandler templateAjaxHandler = this.getAjaxHandler();
        if (templateAjaxHandler == null) {
            throw new ConfigurationException("[THYMELEAF] AJAX Handler set into " + AjaxThymeleafView.class.getSimpleName() + " instance for template " + this.getTemplateName() + " is null.");
        }
        if (templateAjaxHandler.isAjaxRequest(request, response)) {
            Set<String> fragmentsToRender = this.getRenderFragments(model, request, response);
            if (fragmentsToRender == null || fragmentsToRender.size() == 0) {
                vlogger.warn("[THYMELEAF] An Ajax request was detected, but no fragments were specified to be re-rendered.  Falling back to full page render.  This can cause unpredictable results when processing the ajax response on the client.");
                super.render(model, request, response);
                return;
            }
            super.renderFragment(fragmentsToRender, model, request, response);
        } else {
            super.render(model, request, response);
        }
    }

    protected Set<String> getRenderFragments(Map model, HttpServletRequest request, HttpServletResponse response) {
        String fragmentsParam = request.getParameter(FRAGMENTS_PARAM);
        String[] renderFragments = StringUtils.commaDelimitedListToStringArray((String)fragmentsParam);
        if (renderFragments.length == 0) {
            return null;
        }
        if (renderFragments.length == 1) {
            return Collections.singleton(renderFragments[0]);
        }
        return new HashSet<String>(Arrays.asList(renderFragments));
    }
}

