/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.dialect.IProcessorDialect;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.model.IModel;
import org.thymeleaf.model.IModelFactory;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.model.IStandaloneElementTag;
import org.thymeleaf.model.ITemplateEvent;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.spring3.requestdata.RequestDataValueProcessorUtils;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.templatemode.TemplateMode;
import org.unbescape.html.HtmlEscape;

public final class SpringMethodTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor {
    public static final int ATTR_PRECEDENCE = 990;
    public static final String ATTR_NAME = "method";

    public SpringMethodTagProcessor(IProcessorDialect dialect, String dialectPrefix) {
        super(dialect, TemplateMode.HTML, dialectPrefix, ATTR_NAME, 990, false);
    }

    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, String attributeTemplateName, int attributeLine, int attributeCol, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = HtmlEscape.escapeHtml4Xml((String)(expressionResult == null ? null : expressionResult.toString()));
        if (newAttributeValue == null || newAttributeValue.length() == 0) {
            tag.getAttributes().removeAttribute(ATTR_NAME);
            tag.getAttributes().removeAttribute(attributeName);
        } else {
            tag.getAttributes().replaceAttribute(attributeName, ATTR_NAME, newAttributeValue);
        }
        if (newAttributeValue != null && "form".equalsIgnoreCase(tag.getElementName()) && !this.isMethodBrowserSupported(newAttributeValue)) {
            tag.getAttributes().setAttribute(ATTR_NAME, "post");
            IModelFactory modelFactory = context.getConfiguration().getModelFactory(context.getTemplateMode());
            IModel hiddenMethodModel = modelFactory.createModel();
            String type = "hidden";
            String name = "_method";
            String value = RequestDataValueProcessorUtils.processFormFieldValue(context, "_method", newAttributeValue, "hidden");
            IStandaloneElementTag hiddenMethodElementTag = modelFactory.createStandaloneElementTag("input", true);
            hiddenMethodElementTag.getAttributes().setAttribute("type", "hidden");
            hiddenMethodElementTag.getAttributes().setAttribute("name", "_method");
            hiddenMethodElementTag.getAttributes().setAttribute("value", value);
            hiddenMethodModel.add((ITemplateEvent)hiddenMethodElementTag);
            structureHandler.insertImmediatelyAfter(hiddenMethodModel, false);
        }
    }

    protected boolean isMethodBrowserSupported(String method) {
        return "get".equalsIgnoreCase(method) || "post".equalsIgnoreCase(method);
    }
}

